/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoRangeUtil;
import org.autoplot.AutoplotUtil;
import org.autoplot.ExportDataPanel;
import org.autoplot.RenderType;
import org.autoplot.RenderTypeUtil;
import org.autoplot.datasource.AnonymousDataSource;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.DataSourceController;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.LabelConverter;
import org.autoplot.dom.Options;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotController;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementStyle;
import org.autoplot.dom.PlotElementUtil;
import org.autoplot.layout.LayoutConstants;
import org.autoplot.metatree.MetadataUtil;
import org.autoplot.util.RunLaterListener;
import org.das2.components.DasProgressPanel;
import org.das2.components.VerticalSpectrogramAverager;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.HorizontalDragRangeSelectorMouseModule;
import org.das2.event.HorizontalSlicerMouseModule;
import org.das2.event.MouseModule;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.BoundsRenderer;
import org.das2.graph.ContoursRenderer;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.EventsRenderer;
import org.das2.graph.HugeScatterRenderer;
import org.das2.graph.PitchAngleDistributionRenderer;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PolarPlotRenderer;
import org.das2.graph.PsymConnector;
import org.das2.graph.RGBImageRenderer;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.TickCurveRenderer;
import org.das2.graph.VectorPlotRenderer;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.Converter;

public class PlotElementController
extends DomNodeController {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.pec");
    private static final String PENDING_CREATE_DAS_PEER = "createDasPeer";
    private static final String PENDING_RESET_RANGE = "resetRanges";
    private static final String PENDING_SET_DATASET = "setDataSet";
    private static final String PENDING_COMPONENT_OP = "componentOp";
    private static final String PENDING_UPDATE_DATASET = "updateDataSet";
    private static final String PENDING_RESET_DATASOURCEFILTERID = "resetDataSourceFilterId";
    private static final String PENDING_RESET_RENDER_TYPE = "resetRenderType";
    private final Application dom;
    private PlotElement plotElement;
    private PlotElement parentPlotElement;
    private DataSourceFilter dsf;
    public static final int SYMSIZE_DATAPOINT_COUNT = 500;
    public static final int LARGE_DATASET_COUNT = 30000;
    private final Object processLock = new Object();
    private QDataSet processDataSet = null;
    String procressStr = null;
    boolean deleted = false;
    PropertyChangeListener dsfListener = new PropertyChangeListener(){

        public String toString() {
            return "" + PlotElementController.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"dsfListener");
            if (evt.getPropertyName().equals("filters")) {
                if (evt.getOldValue().toString().trim().equals(evt.getNewValue().toString().trim())) {
                    return;
                }
                logger.log(Level.FINE, "property change in DSF means I need to autorange: {0}", evt.getPropertyName());
                PlotElementController.this.setResetRanges(true);
                PlotElementController.this.maybeSetPlotAutorange();
            }
        }
    };
    PropertyChangeListener parentComponentListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == PlotElementController.this.parentPlotElement) {
                int i;
                String[] parentComponents;
                String s = (String)evt.getNewValue();
                String component = ((PlotElementController)PlotElementController.this).plotElement.component;
                CharSequence[] childComponents = component.split("\\|", -2);
                if (childComponents.length == (parentComponents = s.split("\\|", -2)).length && PlotElementController.this.extendedOperation(Arrays.copyOfRange(parentComponents, 0, parentComponents.length - 1), Arrays.copyOfRange(childComponents, 0, parentComponents.length - 1)) && !DataSetOps.changesDimensions((String)parentComponents[parentComponents.length - 1])) {
                    String newc = "|" + parentComponents[parentComponents.length - 1] + String.join((CharSequence)"|", childComponents);
                    childComponents = newc.split("\\|", -2);
                }
                if (!PlotElementController.this.extendedOperation(parentComponents, (String[])childComponents)) {
                    PlotElementController.this.parentPlotElement.setActive(true);
                    return;
                }
                System.arraycopy(parentComponents, 0, childComponents, 0, parentComponents.length);
                StringBuilder sb = new StringBuilder(childComponents[0]);
                for (i = 1; i < parentComponents.length; ++i) {
                    sb.append("|");
                    sb.append(parentComponents[i]);
                }
                for (i = parentComponents.length; i < childComponents.length; ++i) {
                    sb.append("|");
                    sb.append(childComponents[i]);
                }
                PlotElementController.this.plotElement.setComponent(sb.toString());
            } else if (evt.getSource() == PlotElementController.this.plotElement) {
                String component = (String)evt.getNewValue();
                String[] childComponents = component.split("\\|", -2);
                String[] parentComponents = ((PlotElementController)PlotElementController.this).parentPlotElement.component.split("\\|", -2);
                if (!PlotElementController.this.extendedOperation(parentComponents, childComponents)) {
                    logger.log(Level.INFO, "releasing child {0}", ((PlotElementController)PlotElementController.this).plotElement.id);
                    PlotElementController.this.parentPlotElement.setActive(true);
                    ((PlotElementController)PlotElementController.this).dom.controller.deletePlotElement(PlotElementController.this.plotElement);
                    PlotElementController.this.plotElement.removePropertyChangeListener(PlotElementController.this.parentComponentListener);
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i < parentComponents.length; ++i) {
                    sb.append("|");
                    sb.append(childComponents[i]);
                }
                PlotElementController.this.parentPlotElement.setComponent(sb.toString());
            }
        }
    };
    PropertyChangeListener parentElementListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String pid;
            if (PlotElementController.this.parentPlotElement != null) {
                PlotElementController.this.parentPlotElement.removePropertyChangeListener("component", PlotElementController.this.parentComponentListener);
                PlotElementController.this.plotElement.removePropertyChangeListener("component", PlotElementController.this.parentComponentListener);
            }
            if ((pid = PlotElementController.this.plotElement.getParent()).trim().length() == 0) {
                return;
            }
            PlotElement ppe = (PlotElement)((PlotElementController)PlotElementController.this).dom.controller.getElementById(pid);
            if (ppe != null) {
                PlotElementController.this.parentPlotElement = ppe;
                PlotElementController.this.parentPlotElement.addPropertyChangeListener("component", PlotElementController.this.parentComponentListener);
                PlotElementController.this.plotElement.addPropertyChangeListener("component", PlotElementController.this.parentComponentListener);
            }
        }
    };
    PropertyChangeListener plotElementListener = new PropertyChangeListener(){

        public String toString() {
            return "" + PlotElementController.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"plotElementListener");
            logger.log(Level.FINE, "plotElementListener: {0} {1}->{2}", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            if (evt.getPropertyName().equals("renderType") && !PlotElementController.this.isValueAdjusting()) {
                RenderType newRenderType = (RenderType)((Object)evt.getNewValue());
                RenderType oldRenderType = (RenderType)((Object)evt.getOldValue());
                PlotElementController.this.changesSupport.registerPendingChange(PlotElementController.this, "resetRenderType");
                Runnable run = () -> {
                    try {
                        PlotElementController.this.changesSupport.performingChange(PlotElementController.this, "resetRenderType");
                        PlotElementController.this.resetRenderTypeImp(oldRenderType, newRenderType);
                    }
                    finally {
                        PlotElementController.this.changesSupport.changePerformed(PlotElementController.this, "resetRenderType");
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    new Thread(run, "updateDataSetOffEvent").start();
                } else {
                    run.run();
                }
            } else if (evt.getPropertyName().equals("dataSourceFilterId")) {
                PlotElementController.this.changeDataSourceFilter();
                if (PlotElementController.this.dsfReset) {
                    if (evt.getOldValue() != null) {
                        PlotElementController.this.setResetPlotElement(true);
                        PlotElementController.this.setResetRanges(true);
                    }
                    if (evt.getNewValue().equals("")) {
                        if (PlotElementController.this.getRenderer() != null) {
                            PlotElementController.this.getRenderer().setDataSet(null);
                        }
                    } else {
                        PlotElementController.this.changesSupport.registerPendingChange(PlotElementController.this, PlotElementController.PENDING_RESET_DATASOURCEFILTERID);
                        Runnable run = () -> {
                            try {
                                PlotElementController.this.changesSupport.performingChange(PlotElementController.this, PlotElementController.PENDING_RESET_DATASOURCEFILTERID);
                                PlotElementController.this.updateDataSet();
                            }
                            finally {
                                PlotElementController.this.changesSupport.changePerformed(PlotElementController.this, PlotElementController.PENDING_RESET_DATASOURCEFILTERID);
                            }
                        };
                        if (SwingUtilities.isEventDispatchThread()) {
                            new Thread(run, "updateDataSetOffEvent").start();
                        } else {
                            run.run();
                        }
                    }
                }
            } else if (evt.getPropertyName().equals("component")) {
                String oldv = (String)evt.getOldValue();
                oldv = DataSetOps.makeProcessStringCanonical((String)oldv);
                String newv = (String)evt.getNewValue();
                if (DataSetOps.changesDimensions((String)oldv, (String)(newv = DataSetOps.makeProcessStringCanonical((String)newv)))) {
                    if (DataSetOps.changesIndependentDimensions((String)oldv, (String)newv)) {
                        logger.log(Level.FINER, "component property change requires we reset render and dimensions: {0}->{1}", new Object[]{(String)evt.getOldValue(), (String)evt.getNewValue()});
                        PlotElementController.this.setResetPlotElement(true);
                        PlotElementController.this.setResetRanges(true);
                        if (!PlotElementController.this.dom.getController().isValueAdjusting()) {
                            PlotElementController.this.maybeSetPlotAutorange();
                        }
                    } else {
                        logger.log(Level.FINER, "component property change requires we reset just the y-axis: {0}->{1}", new Object[]{(String)evt.getOldValue(), (String)evt.getNewValue()});
                        PlotElementController.this.setResetPlotElement(true);
                        PlotElementController.this.setResetRanges(true);
                        if (!PlotElementController.this.dom.getController().isValueAdjusting()) {
                            PlotElementController.this.maybeSetPlotYZAutorange();
                        }
                    }
                }
                if (PlotElementController.this.sliceAutoranges) {
                    PlotElementController.this.setResetRanges(true);
                    if (!PlotElementController.this.dom.getController().isValueAdjusting()) {
                        PlotElementController.this.maybeSetPlotAutorange();
                    }
                }
                if (newv.startsWith("|")) {
                    PlotElementController.this.dom.getOptions().setDataVisible(true);
                }
                if (PlotElementController.this.changesSupport == null) {
                    logger.severe("changesSupport is null!!!");
                    logger.severe("this is a sad, leftover PlotElementController that should have been GC'd");
                    return;
                }
                PlotElementController.this.changesSupport.registerPendingChange(PlotElementController.this.plotElementListener, PlotElementController.PENDING_COMPONENT_OP);
                Runnable run = () -> {
                    if (PlotElementController.this.changesSupport == null) {
                        logger.severe("changesSupport is null!!!");
                        return;
                    }
                    PlotElementController.this.changesSupport.performingChange(PlotElementController.this.plotElementListener, PlotElementController.PENDING_COMPONENT_OP);
                    PlotElementController.this.setStatus("busy: update data set");
                    try {
                        PlotElementController.this.updateDataSet();
                        PlotElementController.this.setStatus("done update data set");
                    }
                    catch (RuntimeException ex) {
                        PlotElementController.this.setStatus("warning: " + ex.toString());
                        throw ex;
                    }
                    finally {
                        PlotElementController.this.changesSupport.changePerformed(PlotElementController.this.plotElementListener, PlotElementController.PENDING_COMPONENT_OP);
                    }
                };
                RequestProcessor.invokeLater((Runnable)run);
            }
        }
    };
    PropertyChangeListener parentStyleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"parentStyleListener");
            try {
                if (evt.getPropertyName().equals("color")) {
                    logger.fine("ignoring change of parent color.");
                } else {
                    DomUtil.setPropertyValue(((PlotElementController)PlotElementController.this).plotElement.style, evt.getPropertyName(), evt.getNewValue());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    };
    PropertyChangeListener styleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"styleListener");
            if (evt.getPropertyName().equals("rebinMethod") && (PlotElementController.this.plotElement.getRenderType() == RenderType.nnSpectrogram || PlotElementController.this.plotElement.getRenderType() == RenderType.spectrogram)) {
                if (evt.getNewValue() == SpectrogramRenderer.RebinnerEnum.nearestNeighbor) {
                    ((PlotElementController)PlotElementController.this).plotElement.renderType = RenderType.nnSpectrogram;
                } else if (evt.getNewValue() == SpectrogramRenderer.RebinnerEnum.binAverage) {
                    ((PlotElementController)PlotElementController.this).plotElement.renderType = RenderType.spectrogram;
                }
            }
        }
    };
    public static final String PROP_DATASET = "dataSet";
    protected QDataSet dataSet = null;
    PropertyChangeListener exceptionListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"exceptionListener");
            PlotElementController.this.changesSupport.performingChange(this, PlotElementController.PENDING_SET_DATASET);
            try {
                Exception ex = ((PlotElementController)PlotElementController.this).dsf.controller.getException();
                logger.log(Level.FINE, "{0} got exception: {1}  ", new Object[]{PlotElementController.this.plotElement, ex});
                if (PlotElementController.this.resetComponent) {
                    PlotElementController.this.plotElement.setComponent("");
                    ((PlotElementController)PlotElementController.this).plotElement.autoComponent = true;
                    PlotElementController.this.setResetComponent(false);
                }
                PlotElementController.this.renderer.setDataSet(null);
                PlotElementController.this.renderer.setException(ex);
            }
            finally {
                PlotElementController.this.changesSupport.changePerformed(this, PlotElementController.PENDING_SET_DATASET);
            }
        }

        public String toString() {
            return "" + PlotElementController.this;
        }
    };
    PropertyChangeListener fillDataSetListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object object = PlotElementController.this.processLock;
            synchronized (object) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"fillDataSetListener");
                logger.fine("enter fillDataSetListener propertyChange");
                if (!Arrays.asList(PlotElementController.this.dom.getPlotElements()).contains(PlotElementController.this.plotElement)) {
                    return;
                }
                PlotElementController.this.changesSupport.performingChange(this, PlotElementController.PENDING_SET_DATASET);
                try {
                    QDataSet fillDs = ((PlotElementController)PlotElementController.this).dsf.controller.getFillDataSet();
                    logger.log(Level.FINE, "{0} got new dataset: {1}  resetComponent={2}  resetPele={3}  resetRanges={4}", new Object[]{PlotElementController.this.plotElement, fillDs, PlotElementController.this.resetComponent, PlotElementController.this.resetPlotElement, PlotElementController.this.resetRanges});
                    if (PlotElementController.this.resetComponent) {
                        PlotElementController.this.plotElement.setComponentAutomatically("");
                        PlotElementController.this.processDataSet = null;
                        PlotElementController.this.procressStr = null;
                        PlotElementController.this.setResetComponent(false);
                    } else {
                        PlotElementController.this.processDataSet = null;
                    }
                    PlotElementController.this.updateDataSet();
                }
                finally {
                    PlotElementController.this.changesSupport.changePerformed(this, PlotElementController.PENDING_SET_DATASET);
                }
            }
        }

        public String toString() {
            return "" + PlotElementController.this;
        }
    };
    PropertyChangeListener dataSourceDataSetListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"dataSourceDataSetListener");
            if (PlotElementController.this.dsfReset) {
                PlotElementController.this.setResetComponent(true);
                PlotElementController.this.setResetPlotElement(true);
                PlotElementController.this.setResetRanges(true);
                PlotElementController.this.plotElement.setAutoLabel(true);
                PlotElementController.this.plotElement.setAutoComponent(true);
                PlotElementController.this.plotElement.setAutoRenderType(true);
                PlotElementController.this.maybeSetPlotAutorange();
            }
        }
    };
    public static final String PROP_RESETRANGES = "resetRanges";
    private boolean resetRanges = false;
    public static final String PROP_RESETPLOTELEMENT = "resetPlotElement";
    private boolean resetPlotElement = false;
    public static final String PROP_RESETCOMPONENT = "resetComponent";
    private boolean resetComponent = false;
    public static final String PROP_RESETRENDERTYPE = "resetRenderType";
    private boolean resetRenderType = false;
    public static final String PROP_DSFRESET = "dsfReset";
    private boolean dsfReset = true;
    private boolean sliceAutoranges = false;
    public static final String PROP_SLICEAUTORANGES = "sliceAutoranges";
    private static final AtomicInteger renderCount = new AtomicInteger();
    protected Renderer renderer = null;
    PropertyChangeListener rebinnerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"rebinnerListener");
            if (!PlotElementController.this.isValueAdjusting()) {
                PlotElementController.this.plotElement.setAutoRenderType(false);
            }
        }
    };
    private PropertyChangeListener parentComponentLister;

    public PlotElementController(ApplicationModel model, Application dom, PlotElement plotElement) {
        super(plotElement);
        this.dom = dom;
        this.plotElement = plotElement;
        plotElement.addPropertyChangeListener("renderType", this.plotElementListener);
        plotElement.addPropertyChangeListener("dataSourceFilterId", this.plotElementListener);
        plotElement.addPropertyChangeListener("component", this.plotElementListener);
        plotElement.addPropertyChangeListener("parent", this.parentElementListener);
        plotElement.getStyle().addPropertyChangeListener(this.styleListener);
    }

    protected void disconnect() {
        this.plotElement.removePropertyChangeListener("renderType", this.plotElementListener);
        this.plotElement.removePropertyChangeListener("dataSourceFilterId", this.plotElementListener);
        this.plotElement.removePropertyChangeListener("component", this.plotElementListener);
        this.plotElement.removePropertyChangeListener("parent", this.plotElementListener);
        this.plotElement.getStyle().removePropertyChangeListener(this.styleListener);
        PlotElement parent = this.getParentPlotElement();
        if (parent != null) {
            parent.removePropertyChangeListener(this.getParentComponentLister());
        }
        this.plotElement.removePropertyChangeListener(this.getParentComponentLister());
    }

    protected void removeReferences() {
        this.processDataSet = null;
        this.deleted = true;
    }

    public List<PlotElement> getChildPlotElements() {
        ArrayList<PlotElement> result = new ArrayList<PlotElement>();
        for (PlotElement pp : this.dom.plotElements) {
            if (!pp.getParent().equals(this.plotElement.getId())) continue;
            result.add(pp);
        }
        return result;
    }

    protected void setChildPlotElements(List<PlotElement> plotElements) {
        for (PlotElement p : plotElements) {
            p.setParent(this.plotElement.getId());
        }
    }

    protected void setParentPlotElement(PlotElement p) {
        this.plotElement.setParent(p.getId());
    }

    public PlotElement getParentPlotElement() {
        if (this.plotElement.getParent().equals("")) {
            return null;
        }
        for (PlotElement pp : this.dom.plotElements) {
            if (!pp.getId().equals(this.plotElement.getParent())) continue;
            return pp;
        }
        return null;
    }

    public PlotElement getPlotElement() {
        return this.plotElement;
    }

    void unbindDsf() {
        if (this.dsf != null) {
            this.dsf.removePropertyChangeListener("filters", this.dsfListener);
            this.dsf.controller.removePropertyChangeListener("fillDataSet", this.fillDataSetListener);
            this.dsf.controller.removePropertyChangeListener("dataSource", this.dataSourceDataSetListener);
            this.dsf.controller.removePropertyChangeListener("exception", this.exceptionListener);
        }
    }

    private void resetRenderTypeImp(RenderType oldRenderType, RenderType newRenderType) {
        logger.entering("PlotElementController", "resetRenderTypeImp", new Object[]{oldRenderType, newRenderType});
        PlotElement parentEle = this.getParentPlotElement();
        if (parentEle != null) {
            logger.finest("parentEle!=null branch");
            if (parentEle.getRenderType().equals((Object)newRenderType)) {
                if (this.plotElement.getPlotId().length() > 0) {
                    this.doResetRenderTypeInt(newRenderType);
                    this.updateDataSet();
                }
            } else {
                parentEle.setRenderType(newRenderType);
            }
        } else {
            if (PlotElementController.axisDimensionsChange(oldRenderType, newRenderType)) {
                logger.finest("axisDimensionsChange branch");
                this.resetRanges = true;
                if (this.plotElement.getComponent().equals("")) {
                    this.resetPlotElement(this.getDataSourceFilter().getController().getFillDataSet(), this.plotElement.getRenderType(), "");
                } else {
                    QDataSet sliceDs = this.getDataSet();
                    if (sliceDs == null) {
                        sliceDs = this.getDataSourceFilter().getController().getFillDataSet();
                        this.resetPlotElement(sliceDs, this.plotElement.getRenderType(), "");
                    } else {
                        this.resetPlotElement(sliceDs, this.plotElement.getRenderType(), "");
                    }
                }
                this.updateDataSet();
            } else {
                logger.finest("axis dimensions don't change, just reset render type.");
                this.doResetRenderType(newRenderType);
                this.updateDataSet();
            }
            this.setResetPlotElement(false);
        }
        logger.exiting("PlotElementController", "resetRenderTypeImp");
    }

    private boolean sameOperation(String c1, String c2) {
        int ic2;
        int ic1 = c1.indexOf("(");
        if (ic1 != (ic2 = c2.indexOf("("))) {
            return false;
        }
        return c1.substring(0, ic1).equals(c2.substring(0, ic1));
    }

    private boolean extendedOperation(String[] parentComponents, String[] childComponents) {
        if (childComponents.length < parentComponents.length) {
            return false;
        }
        for (int i = 1; i < parentComponents.length; ++i) {
            if (this.sameOperation(parentComponents[i], childComponents[i])) continue;
            return false;
        }
        return true;
    }

    private void changeDataSourceFilter() {
        if (this.dsf != null) {
            this.unbindDsf();
            List<DomNode> usages = DomUtil.dataSourceUsages(this.dom, this.dsf.getId());
            if (usages.isEmpty()) {
                this.dom.controller.deleteDataSourceFilter(this.dsf);
            }
        }
        assert (this.plotElement.getDataSourceFilterId() != null);
        if (this.plotElement.getDataSourceFilterId().equals("")) {
            return;
        }
        this.dsf = this.dom.controller.getDataSourceFilterFor(this.plotElement);
        if (this.dsf == null) {
            logger.log(Level.WARNING, "Unable to find datasource for plotElement {0}", this.plotElement);
            return;
        }
        this.dsf.addPropertyChangeListener("filters", this.dsfListener);
        this.setDataSourceFilterController(this.dsf.controller);
    }

    private Color deriveColor(Color color, int i) {
        float[] colorHSV = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (colorHSV[2] < 0.7f) {
            colorHSV[2] = 0.7f;
        }
        if (colorHSV[1] < 0.7f) {
            colorHSV[1] = 0.7f;
        }
        return Color.getHSBColor((float)i / 6.0f, colorHSV[1], colorHSV[2]);
    }

    private Exception getRootCause(Exception exception) {
        Throwable cause = exception.getCause();
        while (cause != null && cause != exception && cause instanceof Exception) {
            exception = (Exception)cause;
            cause = exception.getCause();
        }
        if (cause != null && cause instanceof Exception) {
            return (Exception)cause;
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QDataSet processDataSet(String c, QDataSet fillDs) throws RuntimeException, Exception {
        this.setStatus("busy: process dataset");
        String label = null;
        c = c.trim();
        if (c.length() > 0 && !c.startsWith("|")) {
            int idx;
            if (!this.plotElement.getComponent().equals("") && fillDs.length() > 0 && (fillDs.rank() == 2 || Schemes.isRank3WaveformXYZ((QDataSet)fillDs))) {
                String[] labels = SemanticOps.getComponentNames((QDataSet)fillDs);
                String comp = this.plotElement.getComponent();
                int ip = comp.indexOf(124);
                if (ip != -1) {
                    comp = comp.substring(0, ip);
                }
                comp = Ops.saferName((String)comp);
                if (fillDs.property("BUNDLE_1") != null || fillDs.property("BUNDLE_2") != null) {
                    fillDs = DataSetOps.unbundle((QDataSet)fillDs, (String)comp);
                    label = comp;
                } else {
                    boolean found = false;
                    for (int i = 0; i < labels.length; ++i) {
                        if (!Ops.saferName((String)labels[i]).equals(comp)) continue;
                        fillDs = DataSetOps.slice1((QDataSet)fillDs, (int)i);
                        label = labels[i];
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new IllegalArgumentException("component not found: " + comp);
                    }
                }
                if (label == null && !this.isPendingChanges()) {
                    RuntimeException ex = new RuntimeException("component not found: " + comp);
                    throw ex;
                }
            }
            c = (idx = c.indexOf(124)) == -1 ? "" : c.substring(idx);
        }
        if (c.length() > 5 && c.startsWith("|")) {
            logger.log(Level.FINE, "component={0}", c);
            if (DataSetOps.isProcessAsync((String)c)) {
                Object object = this.processLock;
                synchronized (object) {
                    if (c.equals(this.procressStr) && this.processDataSet != null) {
                        if (logger.isLoggable(Level.FINE)) {
                            QDataSet bounds = DataSetOps.dependBounds((QDataSet)this.processDataSet);
                            logger.log(Level.FINE, "using cached dataset for {0} bounds:{1}", new Object[]{this.procressStr, bounds.slice(0)});
                        }
                        fillDs = this.processDataSet;
                    } else {
                        this.processDataSet = null;
                        this.procressStr = null;
                        DasProgressPanel mon = DasProgressPanel.createComponentPanel((DasCanvasComponent)this.getDasPlot(), (String)"process data set");
                        fillDs = DataSetOps.sprocess((String)c, (QDataSet)fillDs, (ProgressMonitor)mon);
                        if (mon.isCancelled()) {
                            this.processDataSet = null;
                            this.procressStr = null;
                        } else {
                            this.processDataSet = fillDs;
                            this.procressStr = c;
                        }
                    }
                }
            }
            Object object = this.processLock;
            synchronized (object) {
                this.processDataSet = null;
                this.procressStr = null;
            }
            fillDs = DataSetOps.sprocess((String)c, (QDataSet)fillDs, null);
        }
        this.setStatus("done, process dataset");
        return fillDs;
    }

    private static Map<String, Object> processProperties(String c, Map<String, Object> properties) {
        if ((c = c.trim()).length() > 5 && c.contains("|")) {
            properties = MetadataUtil.sprocess((String)c, properties);
        }
        return properties;
    }

    private boolean rendererAcceptsData(QDataSet fillDs) {
        if (this.getRenderer() instanceof SpectrogramRenderer) {
            switch (fillDs.rank()) {
                case 3: {
                    QDataSet dep0 = (QDataSet)fillDs.property("DEPEND_0");
                    if (dep0 != null) {
                        return false;
                    }
                    return this.rendererAcceptsData((QDataSet)DataSetOps.slice0((QDataSet)fillDs, (int)0));
                }
                case 2: {
                    return true;
                }
            }
            return fillDs.property("PLANE_0") != null;
        }
        if (this.getRenderer() instanceof SeriesRenderer) {
            switch (fillDs.rank()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return SemanticOps.isBundle((QDataSet)fillDs) || SemanticOps.isRank2Waveform((QDataSet)fillDs);
                }
                case 3: {
                    return SemanticOps.isJoin((QDataSet)fillDs) && SemanticOps.isRank2Waveform((QDataSet)fillDs.slice(0));
                }
            }
            return false;
        }
        if (this.getRenderer() instanceof HugeScatterRenderer) {
            switch (fillDs.rank()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return SemanticOps.isBundle((QDataSet)fillDs) || SemanticOps.isRank2Waveform((QDataSet)fillDs);
                }
                case 3: {
                    return SemanticOps.isJoin((QDataSet)fillDs) && SemanticOps.isRank2Waveform((QDataSet)fillDs.slice(0));
                }
            }
            return false;
        }
        if (this.getRenderer() instanceof RGBImageRenderer) {
            switch (fillDs.rank()) {
                case 2: {
                    return !SemanticOps.isBundle((QDataSet)fillDs);
                }
                case 3: {
                    return fillDs.length(0, 0) < 5;
                }
            }
            return false;
        }
        return true;
    }

    private void setDataSet(QDataSet fillDs) throws IllegalArgumentException {
        if (!Arrays.asList(this.dom.getPlotElements()).contains(this.plotElement)) {
            return;
        }
        String comp = this.plotElement.getComponent();
        try {
            if (fillDs != null) {
                QDataSet context;
                Units acu;
                Object altContext;
                Object ocontext;
                if (comp.length() > 0) {
                    fillDs = this.processDataSet(comp, fillDs);
                }
                if (this.doUnitsCheck(fillDs)) {
                    Plot plot = this.dom.getController().getPlotFor(this.plotElement);
                    PlotController pc = plot.getController();
                    pc.doPlotElementDefaultsUnitsChange(this.plotElement);
                }
                if ((ocontext = fillDs.property("CONTEXT_0")) != null && (altContext = fillDs.property("CONTEXT_1")) != null && altContext instanceof QDataSet && (acu = (Units)((QDataSet)altContext).property("UNITS")) != null && UnitsUtil.isTimeLocation((Units)acu)) {
                    ocontext = altContext;
                }
                if (ocontext != null && !(ocontext instanceof QDataSet)) {
                    logger.warning("CONTEXT_0 is not a QDataSet");
                    ocontext = null;
                }
                if ((context = (QDataSet)ocontext) != null) {
                    try {
                        DatumRange cdr = context.rank() == 1 ? DataSetUtil.asDatumRange((QDataSet)context, (boolean)true) : DatumRange.newRange((double)context.value(), (double)context.value(), (Units)SemanticOps.getUnits((QDataSet)context));
                        Plot plot = this.dom.getController().getPlotFor(this.plotElement);
                        plot.getController().getDasPlot().setDisplayContext(cdr);
                    }
                    catch (IllegalArgumentException ex) {
                        logger.fine(ex.toString());
                    }
                }
            }
            logger.log(Level.FINE, "  postOpsDataSet: {0}", String.valueOf(fillDs));
            this.setDataSetInternal(fillDs);
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINE, "runtime exception caught: {0}", new Object[]{ex});
            if (this.getRenderer() == null) {
                throw ex;
            }
            this.getRenderer().setDataSet(null);
            this.getRenderer().setException(this.getRootCause(ex));
            this.setDataSetInternal(null);
            return;
        }
        catch (CancelledOperationException ex) {
            this.getRenderer().setDataSet(null);
            this.getRenderer().setException(this.getRootCause((Exception)((Object)ex)));
            this.setDataSetInternal(null);
            return;
        }
        catch (Exception ex) {
            this.getRenderer().setDataSet(null);
            this.getRenderer().setException(this.getRootCause(ex));
            this.setDataSetInternal(null);
            return;
        }
        if (fillDs != null && this.getRenderer() != null) {
            if (this.rendererAcceptsData(fillDs)) {
                this.getRenderer().setDataSet(fillDs);
            } else {
                this.getRenderer().setDataSet(null);
                this.getRenderer().setException(new Exception("renderer cannot plot " + fillDs));
            }
        }
    }

    public QDataSet getDataSet() {
        return this.dataSet;
    }

    private void setDataSetInternal(QDataSet dataSet) {
        logger.log(Level.FINE, "setDataSetInternal {0}", dataSet);
        QDataSet oldDataSet = this.dataSet;
        this.dataSet = dataSet;
        if ((this.plotElement.getLegendLabel().contains("%{") || this.plotElement.getLegendLabel().contains("$(")) && this.renderer != null) {
            String s = (String)this.getLabelConverter().convertForward((Object)this.plotElement.getLegendLabel());
            this.renderer.setLegendLabel(s);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_DATASET, oldDataSet, dataSet);
    }

    private boolean sliceShouldAutorange(QDataSet fillDs, String component) throws NumberFormatException {
        int dim;
        Units[] us = PlotElementController.getDimensionUnits(fillDs);
        Pattern p = Pattern.compile("\\|slice(\\d)\\(\\d+\\)");
        Matcher m = p.matcher(component);
        return m.matches() && UnitsUtil.isNominalMeasurement((Units)us[dim = Integer.parseInt(m.group(1))]);
    }

    public static String resolveRenderType(QDataSet fillds) {
        String srenderType = (String)fillds.property("RENDER_TYPE");
        String renderControl = "";
        if (srenderType != null && srenderType.trim().length() > 0) {
            RenderType renderType;
            int i = srenderType.indexOf(62);
            if (i == -1) {
                renderControl = "";
            } else {
                renderControl = srenderType.substring(i + 1);
                srenderType = srenderType.substring(0, i);
            }
            boolean useHugeScatter = "true".equals(System.getProperty("useHugeScatter", "true"));
            switch (srenderType) {
                case "time_series": {
                    if (useHugeScatter && fillds.length() > 80000) {
                        renderType = RenderType.hugeScatter;
                        break;
                    }
                    renderType = RenderType.series;
                    break;
                }
                case "waveform": {
                    if (useHugeScatter) {
                        renderType = RenderType.hugeScatter;
                        break;
                    }
                    renderType = RenderType.series;
                    break;
                }
                case "spectrogram": {
                    RenderType specPref = RenderType.spectrogram;
                    Options o = new Options();
                    Preferences prefs = AutoplotSettings.settings().getPreferences(o.getClass());
                    boolean nn = prefs.getBoolean("nearestNeighbor", o.isNearestNeighbor());
                    if (nn) {
                        specPref = RenderType.nnSpectrogram;
                    }
                    renderType = specPref;
                    break;
                }
                default: {
                    try {
                        renderType = RenderType.valueOf(srenderType);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        renderType = AutoplotUtil.guessRenderType(fillds);
                    }
                }
            }
            return renderType.toString() + ">" + renderControl;
        }
        RenderType renderType = AutoplotUtil.guessRenderType(fillds);
        if (renderType == RenderType.series && Schemes.isScalarSeriesWithErrors((QDataSet)fillds)) {
            renderControl = "drawError=T";
        }
        return renderType.toString() + ">" + renderControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataSetImmediately() throws Exception {
        this.performingChange(this, PENDING_UPDATE_DATASET);
        try {
            if (this.dsf == null) {
                this.getRenderer().setDataSet(null);
                this.getRenderer().setException((Exception)new RuntimeException("Data Source Reference"));
                return;
            }
            QDataSet fillDs = this.dsf.controller.getFillDataSet();
            Throwable renderException = null;
            if (fillDs != null) {
                String comp = DataSetOps.makeProcessStringCanonical((String)this.plotElement.getComponent().trim());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "updateDataSetImmediately: {0} {1}", new Object[]{this.plotElement, this.plotElement.getRenderType()});
                    logger.log(Level.FINE, "  resetPlotElement: {0}", this.resetPlotElement);
                    logger.log(Level.FINE, "  resetRanges: {0}", this.resetRanges);
                    logger.log(Level.FINE, "  resetRenderType: {0}", this.resetRenderType);
                    logger.log(Level.FINE, "  component: {0}", comp);
                    logger.log(Level.FINE, "  dataSet: {0}", String.valueOf(fillDs));
                }
                if (this.resetPlotElement) {
                    if (comp.equals("")) {
                        int i;
                        String s = PlotElementController.resolveRenderType(fillDs);
                        RenderType renderType = RenderType.valueOf(s.substring(0, i = s.indexOf(62)));
                        if (!renderType.equals((Object)this.plotElement.renderType) && this.getRenderer() != null) {
                            this.getRenderer().setDataSet(null);
                        }
                        this.plotElement.renderType = renderType;
                        this.resetPlotElement(fillDs, renderType, s.substring(i + 1));
                        this.setResetPlotElement(false);
                    } else if (comp.startsWith("|")) {
                        try {
                            RenderType renderType;
                            QDataSet fillDs2 = fillDs;
                            if (comp.length() > 0) {
                                fillDs2 = this.processDataSet(comp, fillDs2);
                            }
                            if (fillDs2 == null) {
                                throw new NullPointerException("operations result in null: " + comp);
                            }
                            String s = PlotElementController.resolveRenderType(fillDs2);
                            int i = s.indexOf(62);
                            if (i == -1) {
                                i = s.length();
                            }
                            if (!(renderType = RenderType.valueOf(s.substring(0, i))).equals((Object)this.plotElement.renderType) && this.getRenderer() != null) {
                                this.getRenderer().setDataSet(null);
                            }
                            this.plotElement.renderType = renderType;
                            this.resetPlotElement(fillDs2, renderType, s.substring(i + 1));
                            this.setResetPlotElement(false);
                        }
                        catch (CancelledOperationException ex) {
                            this.setStatus("warning: Filters were cancelled: " + (Object)((Object)ex));
                            this.getRenderer().setDataSet(null);
                            this.getRenderer().setException((Exception)((Object)ex));
                            renderException = ex;
                        }
                        catch (RuntimeException ex) {
                            if (this.getRenderer() == null) {
                                System.err.println("NullPointerEx has happened, see bug https://sourceforge.net/p/autoplot/bugs/2635/");
                                ex.printStackTrace();
                            }
                            this.setStatus("warning: Exception in process: " + ex);
                            this.getRenderer().setDataSet(null);
                            this.getRenderer().setException(this.getRootCause(ex));
                            renderException = ex;
                        }
                    } else {
                        if (this.renderer == null) {
                            this.maybeCreateDasPeer();
                        }
                        try {
                            if (this.resetRanges) {
                                this.doResetRanges();
                            }
                            this.setResetPlotElement(false);
                        }
                        catch (RuntimeException ex) {
                            this.setStatus("warning: Exception in process: " + ex);
                            this.getRenderer().setDataSet(null);
                            this.getRenderer().setException(this.getRootCause(ex));
                            renderException = ex;
                        }
                    }
                } else if (this.resetRanges) {
                    this.doResetRanges();
                    this.setResetRanges(false);
                } else if (this.resetRenderType) {
                    this.doResetRenderType(this.plotElement.getRenderType());
                }
            }
            if (fillDs == null) {
                if (this.getRenderer() != null) {
                    this.getRenderer().setDataSet(null);
                    this.getRenderer().setException(null);
                }
                this.setDataSet(null);
            } else if (renderException == null) {
                this.setDataSet(fillDs);
            }
        }
        finally {
            this.changePerformed(this, PENDING_UPDATE_DATASET);
        }
    }

    private void updateDataSet() throws IllegalArgumentException {
        if (EventQueue.isDispatchThread()) {
            // empty if block
        }
        this.registerPendingChange(this, PENDING_UPDATE_DATASET);
        if (!this.dom.controller.isValueAdjusting()) {
            Runnable run = () -> {
                try {
                    this.updateDataSetImmediately();
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    throw new IllegalArgumentException(ex);
                }
            };
            run.run();
        } else {
            new RunLaterListener("valueAdjusting", this.dom.controller, true){

                @Override
                public void run() {
                    try {
                        PlotElementController.this.updateDataSetImmediately();
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            };
        }
    }

    private static RenderType canonicalRenderType(RenderType t) {
        switch (t) {
            case nnSpectrogram: 
            case spectrogram: {
                return RenderType.spectrogram;
            }
            case scatter: 
            case series: 
            case colorScatter: 
            case fillToZero: 
            case stairSteps: 
            case hugeScatter: {
                return RenderType.series;
            }
        }
        return t;
    }

    public static boolean axisDimensionsChange(RenderType oldRenderType, RenderType newRenderType) {
        if (oldRenderType == newRenderType) {
            return false;
        }
        if (newRenderType == RenderType.pitchAngleDistribution) {
            return true;
        }
        if (newRenderType == RenderType.polar) {
            return true;
        }
        if (oldRenderType == RenderType.spectrogram && newRenderType == RenderType.nnSpectrogram) {
            return false;
        }
        if (oldRenderType == RenderType.nnSpectrogram && newRenderType == RenderType.spectrogram) {
            return false;
        }
        if (newRenderType == RenderType.spectrogram || newRenderType == RenderType.nnSpectrogram) {
            return true;
        }
        if (newRenderType == RenderType.eventsBar) {
            return oldRenderType == RenderType.digital || PlotElementController.canonicalRenderType(oldRenderType) == RenderType.series;
        }
        if (oldRenderType == RenderType.spectrogram || oldRenderType == RenderType.nnSpectrogram) {
            return true;
        }
        if (oldRenderType == RenderType.scatter || oldRenderType == RenderType.series || oldRenderType == RenderType.fillToZero || oldRenderType == RenderType.stairSteps) {
            return false;
        }
        return false;
    }

    private static String[] getDimensionNames(QDataSet ds) {
        String[] depNames = new String[ds.rank()];
        for (int i = 0; i < ds.rank(); ++i) {
            String dname;
            depNames[i] = "dim" + i;
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep0 == null || (dname = (String)dep0.property("NAME")) == null) continue;
            depNames[i] = dname;
        }
        return depNames;
    }

    private static Units[] getDimensionUnits(QDataSet ds) {
        Units[] depUnits = new Units[ds.rank()];
        for (int i = 0; i < ds.rank(); ++i) {
            Units u;
            depUnits[i] = Units.dimensionless;
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep0 == null || (u = (Units)dep0.property("UNITS")) == null) continue;
            depUnits[i] = u;
        }
        return depUnits;
    }

    private static String guessSliceSlices(QDataSet fillDs, List<Integer> slicePref) {
        int i;
        StringBuilder newResult = new StringBuilder("|slices(");
        String[] slices = new String[fillDs.rank()];
        for (int i2 = 0; i2 < fillDs.rank(); ++i2) {
            slices[i2] = "':'";
        }
        ArrayList<Integer> slicePref1 = new ArrayList<Integer>();
        slicePref1.addAll(slicePref);
        slicePref = slicePref1;
        int ndim = fillDs.rank();
        int nslice = fillDs.rank() - 2;
        ArrayList<Integer> qube = new ArrayList<Integer>();
        int[] a = DataSetUtil.qubeDims((QDataSet)fillDs);
        for (i = 0; i < a.length; ++i) {
            qube.add(a[i]);
        }
        for (int islice = 0; islice < nslice; ++islice) {
            int sliceIndex = 0;
            int bestSlice = 0;
            for (int i3 = 0; i3 < a.length; ++i3) {
                if (slicePref.get(i3) <= bestSlice) continue;
                sliceIndex = i3;
                bestSlice = slicePref.get(i3);
            }
            slicePref.set(sliceIndex, 0);
            slices[sliceIndex] = String.valueOf((Integer)qube.get(sliceIndex) / 2);
        }
        for (i = 0; i < ndim; ++i) {
            newResult.append(slices[i]);
            if (i >= ndim - 1) continue;
            newResult.append(",");
        }
        newResult.append(")");
        return newResult.toString();
    }

    private static String guessSlice(QDataSet fillDs) {
        int i;
        String[] depNames = PlotElementController.getDimensionNames(fillDs);
        Units[] depUnits = PlotElementController.getDimensionUnits(fillDs);
        int Y = -1;
        int X = -1;
        int rank = fillDs.rank();
        if (rank == 3 && Schemes.isPolyMesh((QDataSet)fillDs)) {
            return "";
        }
        ArrayList<Integer> slicePref = new ArrayList<Integer>(rank);
        for (i = 0; i < fillDs.rank(); ++i) {
            slicePref.add(2);
        }
        for (i = 0; i < rank; ++i) {
            String n = depNames[i].toLowerCase();
            Units u = depUnits[i];
            if (n.startsWith("lat")) {
                slicePref.set(i, 0);
                Y = i;
                continue;
            }
            if (n.startsWith("lon")) {
                slicePref.set(i, 0);
                X = i;
                continue;
            }
            if (n.startsWith("vperp")) {
                slicePref.set(i, 0);
                X = i;
                continue;
            }
            if (n.startsWith("vpar")) {
                slicePref.set(i, 0);
                Y = i;
                continue;
            }
            if (n.contains("time")) {
                slicePref.set(i, 1);
                continue;
            }
            if (n.contains("epoch") || UnitsUtil.isTimeLocation((Units)u)) {
                slicePref.set(i, 1);
                continue;
            }
            if (n.contains("angle")) {
                slicePref.set(i, 4);
                continue;
            }
            if (n.contains("alpha")) {
                slicePref.set(i, 4);
                continue;
            }
            if (n.contains("bundle")) {
                slicePref.set(i, 4);
                continue;
            }
            if (u instanceof EnumerationUnits) {
                slicePref.set(i, 5);
                continue;
            }
            if (fillDs.property("BUNDLE_" + i) == null || fillDs.property("DEPEND_" + i) != null) continue;
            slicePref.set(i, 5);
        }
        ArrayList<Integer> qube = new ArrayList<Integer>();
        int[] a = DataSetUtil.qubeDims((QDataSet)fillDs);
        if (a == null) {
            return "|slice0(" + fillDs.length() / 2 + ")";
        }
        for (int i2 = 0; i2 < rank; ++i2) {
            qube.add(a[i2]);
        }
        boolean transpose = false;
        String result = "";
        int nslice = fillDs.rank() - 2;
        String newResult = PlotElementController.guessSliceSlices(fillDs, slicePref);
        if (rank > 4) {
            return newResult;
        }
        for (int islice = 0; islice < nslice; ++islice) {
            int[] qubeDims;
            int sliceIndex = 0;
            int bestSlice = 0;
            boolean noPref = true;
            for (int i3 = 0; i3 < slicePref.size(); ++i3) {
                if (i3 > 0 && ((Integer)slicePref.get(i3)).equals(slicePref.get(i3 - 1))) {
                    noPref = false;
                }
                if ((Integer)slicePref.get(i3) <= bestSlice) continue;
                sliceIndex = i3;
                bestSlice = (Integer)slicePref.get(i3);
            }
            if (noPref && (qubeDims = DataSetUtil.qubeDims((QDataSet)fillDs)) != null) {
                int imin = -1;
                int min = Integer.MAX_VALUE;
                int nextMin = Integer.MAX_VALUE;
                for (int i4 = 0; i4 < qubeDims.length; ++i4) {
                    if (qubeDims[i4] >= min) continue;
                    nextMin = min;
                    min = qubeDims[i4];
                    imin = i4;
                }
                if (min < 4 && nextMin > 10) {
                    sliceIndex = imin;
                }
            }
            if (Schemes.isArrayOfBoundingBox((QDataSet)fillDs)) {
                return "";
            }
            int n = Math.max(0, (Integer)qube.get(sliceIndex) / 2 - 1);
            result = result + "|slice" + sliceIndex + "(" + n + ")";
            if (Y > -1 && X > -1 && Y < X) {
                result = result + "|transpose()";
                transpose = true;
            }
            slicePref.remove(sliceIndex);
            qube.remove(sliceIndex);
        }
        if (transpose) {
            newResult = newResult + "|transpose()";
        }
        if (nslice < 2) {
            return result;
        }
        return newResult;
    }

    private boolean isLastDimBundle(QDataSet ds) {
        switch (ds.rank()) {
            case 1: {
                return ds.property("BUNDLE_0") != null;
            }
            case 2: {
                return ds.property("BUNDLE_1") != null;
            }
            case 3: {
                boolean result = ds.property("BUNDLE_1", 0) != null;
                QDataSet dep1 = (QDataSet)ds.property("DEPEND_1", 0);
                if (dep1 != null && dep1.property("UNITS") instanceof EnumerationUnits) {
                    result = true;
                }
                return result;
            }
        }
        return false;
    }

    private boolean dissimilarChannels(String[] chs) {
        char c;
        if (chs[0].length() == 0) {
            return true;
        }
        char allStartWith = c = chs[0].charAt(0);
        boolean allNumbers = Character.isDigit(c) || c == '.';
        for (String ch : chs) {
            if (ch.length() == 0) {
                return true;
            }
            c = ch.charAt(0);
            if (!(allNumbers ? !Character.isDigit(c) && c != '.' : c != allStartWith)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetPlotElement(QDataSet fillDs, RenderType renderType, String renderControl) {
        logger.log(Level.FINE, "resetPlotElement({0} {1}) ele={2}", new Object[]{fillDs, renderType, this.plotElement});
        if (fillDs != null) {
            List<PlotElement> children;
            boolean alreadyHaveChildren;
            QDataSet bdesc;
            Object context0;
            boolean shouldSlice;
            int ndim = Ops.dimensionCount((QDataSet)fillDs);
            boolean isxyz = SemanticOps.isBundle((QDataSet)fillDs) && fillDs.property("DEPEND_0") == null;
            boolean bl = shouldSlice = fillDs.rank() > 2 && !Schemes.isRank3WaveformXYZ((QDataSet)fillDs) && ndim > 3 && this.plotElement.isAutoComponent() && !isxyz;
            if (renderType == RenderType.image && fillDs.rank() == 3) {
                shouldSlice = false;
            }
            QDataSet sliceDs = fillDs;
            String existingComponent = this.plotElement.getComponent();
            if (shouldSlice && existingComponent.length() > 0) {
                try {
                    sliceDs = DataSetOps.sprocess((String)existingComponent, (QDataSet)fillDs, (ProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            boolean isWaveform = false;
            if (SemanticOps.isRank2Waveform((QDataSet)fillDs)) {
                isWaveform = true;
            }
            boolean shouldHaveChildren = fillDs.rank() == 2 && !isxyz && !isWaveform && (renderType == RenderType.hugeScatter || renderType == RenderType.series || renderType == RenderType.scatter || renderType == RenderType.stairSteps);
            boolean isRank3WaveformXYZ = Schemes.isRank3WaveformXYZ((QDataSet)fillDs);
            if (isRank3WaveformXYZ) {
                shouldHaveChildren = true;
            }
            if (fillDs.rank() == 2 && SemanticOps.isBundle((QDataSet)fillDs) && null != (context0 = (bdesc = (QDataSet)fillDs.property("BUNDLE_1")).property("CONTEXT_0", bdesc.length() - 1)) && context0 instanceof String) {
                shouldHaveChildren = false;
            }
            boolean bl2 = alreadyHaveChildren = !(children = this.getChildPlotElements()).isEmpty();
            if (!alreadyHaveChildren || shouldHaveChildren) {
                // empty if block
            }
            if (logger.isLoggable(Level.FINER)) {
                Application application = this.dom;
                synchronized (application) {
                    logger.finer("###############");
                    logger.finer("" + this.plotElement.getId() + " " + this.getChildPlotElements());
                    logger.finer("shouldHaveChildren: " + shouldHaveChildren);
                    logger.finer("###############");
                }
            }
            String[] lnames = null;
            String[] llabels = null;
            if (shouldHaveChildren) {
                lnames = SemanticOps.getComponentNames((QDataSet)fillDs);
                llabels = SemanticOps.getComponentLabels((QDataSet)fillDs);
            }
            boolean weShallAddChildren = shouldHaveChildren;
            if (!shouldHaveChildren || weShallAddChildren) {
                List<PlotElement> childEles = this.getChildPlotElements();
                for (PlotElement p : childEles) {
                    PlotElementController pec = p.getController();
                    if (this.dom.plotElements.contains(p)) {
                        this.dom.controller.deletePlotElement(p);
                        PropertyChangeListener parentListener = pec.getParentComponentLister();
                        if (parentListener != null) {
                            this.plotElement.removePropertyChangeListener(parentListener);
                        }
                        this.removePropertyChangeListener(this.dsfListener);
                    }
                    this.plotElement.getStyle().removePropertyChangeListener(pec.parentStyleListener);
                }
            }
            if (!shouldSlice) {
                this.doResetRenderType(this.plotElement.getRenderType());
            }
            this.setResetPlotElement(false);
            if (this.resetRanges && !shouldSlice && !weShallAddChildren) {
                boolean doTurnOn;
                boolean bl3 = doTurnOn = this.getParentPlotElement() == null && !this.renderer.isActive();
                if (doTurnOn) {
                    this.renderer.setActive(true);
                }
                this.doResetRanges();
                this.setResetRanges(false);
                if (doTurnOn) {
                    this.renderer.setActive(false);
                }
            } else if (weShallAddChildren) {
                this.doResetRanges();
            }
            if (shouldHaveChildren) {
                this.renderer.setActive(false);
                this.plotElement.setDisplayLegend(false);
            }
            if (shouldSlice) {
                String component = PlotElementController.guessSlice(sliceDs);
                this.setSliceAutoranges(this.sliceShouldAutorange(fillDs, component));
                if (!existingComponent.equals("")) {
                    if (component.equals(existingComponent)) {
                        logger.fine("here again...");
                    }
                    this.plotElement.setComponentAutomatically(existingComponent + component);
                } else {
                    this.plotElement.setComponentAutomatically(component);
                }
                this.doResetRenderType(this.plotElement.getRenderType());
                return;
            }
            if (weShallAddChildren) {
                ChangesSupport.DomLock lock = this.dom.controller.mutatorLock();
                lock.lock("Add Child Elements");
                try {
                    int i;
                    Color c = this.plotElement.getStyle().getColor();
                    Color fc = this.plotElement.getStyle().getFillColor();
                    Plot domPlot = this.dom.controller.getPlotFor(this.plotElement);
                    int count = !isRank3WaveformXYZ ? Math.min(96, fillDs.length(0)) : Math.min(96, fillDs.length(0, 0));
                    ArrayList<PlotElement> cp = new ArrayList<PlotElement>(count);
                    int nsubsample = 1 + (count - 1) / 12;
                    boolean dissimilarChannels = this.dissimilarChannels(lnames);
                    if (dissimilarChannels) {
                        nsubsample = 1 + (count - 1) / 64;
                    }
                    boolean uniqLabels = true;
                    assert (lnames != null);
                    Pattern p = Pattern.compile("ch_\\d+");
                    for (i = 0; i < lnames.length; ++i) {
                        if (AutoplotUtil.isParsableDouble(lnames[i])) {
                            uniqLabels = false;
                        }
                        if (p.matcher(lnames[i]).matches()) {
                            uniqLabels = false;
                        }
                        if (!uniqLabels) continue;
                        for (int j = i + 1; j < lnames.length; ++j) {
                            if (!lnames[i].equals(lnames[j])) continue;
                            uniqLabels = false;
                        }
                    }
                    for (i = 0; i < count; ++i) {
                        QDataSet ds1;
                        PlotElement ele = this.dom.controller.makeChildPlotElement(this.plotElement, domPlot, this.dsf);
                        cp.add(ele);
                        this.plotElement.getStyle().addPropertyChangeListener(ele.controller.parentStyleListener);
                        ele.getStyle().setColor(this.deriveColor(c, i / nsubsample));
                        ele.getStyle().setFillColor(this.deriveColor(fc, i / nsubsample).brighter());
                        String s = existingComponent;
                        String label1 = lnames[i];
                        if (s.equals("") && uniqLabels) {
                            s = lnames[i];
                            ds1 = DataSetOps.unbundle((QDataSet)fillDs, (int)i);
                            String l1 = (String)ds1.property("LABEL");
                            if (l1 == null) {
                                l1 = llabels[i];
                            }
                            if (l1 != null) {
                                label1 = l1;
                            }
                        } else if (s.equals("")) {
                            ds1 = DataSetOps.unbundle((QDataSet)fillDs, (int)i);
                            QDataSet context = (QDataSet)ds1.property("CONTEXT_0");
                            if (context != null) {
                                if (context.rank() == 1) {
                                    context = ArrayDataSet.copy((QDataSet)((QDataSet)ds1.property("CONTEXT_0")));
                                    context = Ops.putProperty((QDataSet)context, (String)"DELTA_MINUS", null);
                                    context = Ops.putProperty((QDataSet)context, (String)"DELTA_PLUS", null);
                                    context = Ops.putProperty((QDataSet)context, (String)"BIN_MINUS", null);
                                    context = Ops.putProperty((QDataSet)context, (String)"BIN_PLUS", null);
                                    label1 = Ops.valid((QDataSet)(context = Ops.extent((QDataSet)context)).slice(0)).value() > 0.0 ? (context.value(0) == context.value(1) ? context.slice(0).toString() : context.toString()) : "fill";
                                } else if (!"slice1".equals(context.property("NAME"))) {
                                    label1 = context.toString();
                                }
                                s = lnames[i];
                            } else if (uniqLabels) {
                                label1 = llabels[i];
                                s = lnames[i];
                            } else {
                                label1 = "ch_" + i;
                                s = s + "|unbundle('ch_" + i + "')";
                            }
                        } else {
                            s = uniqLabels ? s + "|unbundle('" + lnames[i] + "')" : s + "|unbundle('ch_" + i + "')";
                            label1 = llabels[i];
                        }
                        ele.setComponentAutomatically(s);
                        ele.setActive(false);
                        ele.setDisplayLegend(true);
                        ele.setLegendLabelAutomatically(label1);
                        ele.setRenderTypeAutomatically(this.plotElement.getRenderType());
                        ele.controller.maybeCreateDasPeer();
                    }
                    for (i = 0; i < count; ++i) {
                        PlotElement ele = (PlotElement)cp.get(i);
                        if (i % nsubsample == 0) {
                            ele.setActive(true);
                            ele.controller.getRenderer().setActive(true);
                            continue;
                        }
                        ele.setActive(false);
                        ele.controller.getRenderer().setActive(false);
                    }
                    this.renderer.setActive(false);
                    this.setChildPlotElements(cp);
                }
                finally {
                    lock.unlock();
                }
            } else if (this.plotElement.controller.getParentPlotElement() == null) {
                this.renderer.setControl(renderControl);
                this.renderer.setActive(true);
            }
        } else {
            this.doResetRenderType(this.plotElement.getRenderType());
        }
    }

    private boolean xaxisFreeFromBindings(Plot p) {
        boolean isNotBound = true;
        List<BindingModel> l = DomUtil.findBindings(this.dom, p.xaxis, "range");
        String xaxisId = p.getXaxis().getId();
        for (BindingModel bm : l) {
            if (bm.getSrcId().equals(this.dom.getId())) {
                List<BindingModel> l2 = DomUtil.findBindings(this.dom, this.dom, "timeRange");
                if (l2.size() <= 1) continue;
                isNotBound = false;
                continue;
            }
            if (bm.getSrcId().equals(xaxisId)) {
                if (bm.getDstId().equals(xaxisId) || !bm.getDstProperty().equals("range")) continue;
                isNotBound = false;
                continue;
            }
            if (!bm.getDstId().equals(xaxisId) || bm.getSrcId().equals(xaxisId) || !bm.getSrcProperty().equals("range")) continue;
            isNotBound = false;
        }
        return isNotBound;
    }

    private void maybeSetPlotYZAutorange() {
        Plot p = this.dom.controller.getPlotFor(this.plotElement);
        if (p == null) {
            return;
        }
        List<PlotElement> eles = this.dom.controller.getPlotElementsFor(p);
        if (DomUtil.oneFamily(eles)) {
            p.getYaxis().setAutoRange(true);
            p.getZaxis().setAutoRange(true);
            p.getYaxis().setAutoLabel(true);
            p.getZaxis().setAutoLabel(true);
            p.setAutoLabel(true);
            p.setAutoBinding(true);
        }
    }

    private void maybeSetPlotAutorange() {
        Plot p = this.dom.controller.getPlotFor(this.plotElement);
        if (p == null) {
            return;
        }
        List<PlotElement> eles = this.dom.controller.getPlotElementsFor(p);
        if (DomUtil.oneFamily(eles)) {
            p.getXaxis().setAutoRange(this.xaxisFreeFromBindings(p));
            p.getYaxis().setAutoRange(true);
            p.getZaxis().setAutoRange(true);
            p.getXaxis().setAutoLabel(true);
            p.getYaxis().setAutoLabel(true);
            p.getZaxis().setAutoLabel(true);
            p.setAutoLabel(true);
            p.setAutoBinding(true);
        }
    }

    private void setDataSourceFilterController(DataSourceController dsc) {
        dsc.addPropertyChangeListener("fillDataSet", this.fillDataSetListener);
        dsc.addPropertyChangeListener("dataSource", this.dataSourceDataSetListener);
        dsc.addPropertyChangeListener("exception", this.exceptionListener);
    }

    public boolean isResetRanges() {
        return this.resetRanges;
    }

    public void setResetRanges(boolean resetRanges) {
        logger.log(Level.FINE, "{0}.setResetRanges({1})", new Object[]{this.plotElement.id, resetRanges});
        boolean oldResetRanges = this.resetRanges;
        this.resetRanges = resetRanges;
        this.propertyChangeSupport.firePropertyChange("resetRanges", oldResetRanges, resetRanges);
    }

    public boolean isResetPlotElement() {
        return this.resetPlotElement;
    }

    public void setResetPlotElement(boolean resetPlotElement) {
        logger.log(Level.FINE, "{0}.setResetPlotElement({1})", new Object[]{this.plotElement.id, resetPlotElement});
        boolean old = this.resetPlotElement;
        this.resetPlotElement = resetPlotElement;
        this.propertyChangeSupport.firePropertyChange(PROP_RESETPLOTELEMENT, old, resetPlotElement);
    }

    public boolean isResetComponent() {
        return this.resetComponent;
    }

    public void setResetComponent(boolean resetComponent) {
        boolean oldResetComponent = this.resetComponent;
        this.resetComponent = resetComponent;
        this.propertyChangeSupport.firePropertyChange(PROP_RESETCOMPONENT, oldResetComponent, resetComponent);
    }

    public boolean isResetRenderType() {
        return this.resetRenderType;
    }

    public void setResetRenderType(boolean resetRenderType) {
        boolean oldResetRenderType = this.resetRenderType;
        this.resetRenderType = resetRenderType;
        this.propertyChangeSupport.firePropertyChange("resetRenderType", oldResetRenderType, resetRenderType);
    }

    public boolean isDsfReset() {
        return this.dsfReset;
    }

    public void setDsfReset(boolean dsfReset) {
        boolean oldDsfReset = this.dsfReset;
        this.dsfReset = dsfReset;
        this.propertyChangeSupport.firePropertyChange(PROP_DSFRESET, oldDsfReset, dsfReset);
    }

    public boolean isSliceAutoranges() {
        return this.sliceAutoranges;
    }

    public void setSliceAutoranges(boolean sliceAutoranges) {
        boolean oldSliceAutoranges = this.sliceAutoranges;
        this.sliceAutoranges = sliceAutoranges;
        this.propertyChangeSupport.firePropertyChange(PROP_SLICEAUTORANGES, oldSliceAutoranges, sliceAutoranges);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        JMenuItem mi;
        logger.entering("PlotElementController", "setRenderer");
        Renderer oldRenderer = this.renderer;
        ApplicationController ac = this.dom.controller;
        if (oldRenderer != null) {
            ac.unbind(this.plotElement, "legendLabel", oldRenderer, "legendLabel");
            ac.unbind(this.plotElement, "displayLegend", oldRenderer, "drawLegendLabel");
            ac.unbind(this.plotElement, "renderControl", oldRenderer, "control");
            ac.unbind(this.plotElement, "active", oldRenderer, "active");
        }
        this.renderer = renderer;
        ac.unbindImpl(this.node);
        ac.unbindImpl(((PlotElement)this.node).getStyle());
        if (this.node != this.plotElement) {
            logger.fine("node!=plotElement");
        }
        if (renderer instanceof SeriesRenderer) {
            this.bindToSeriesRenderer((SeriesRenderer)renderer);
        } else if (renderer instanceof SpectrogramRenderer) {
            this.bindToSpectrogramRenderer((SpectrogramRenderer)renderer);
        } else if (renderer instanceof HugeScatterRenderer) {
            this.bindToImageVectorDataSetRenderer((HugeScatterRenderer)renderer);
        } else if (renderer instanceof EventsRenderer) {
            this.bindToEventsRenderer((EventsRenderer)renderer);
        } else if (renderer instanceof DigitalRenderer) {
            this.bindToDigitalRenderer((DigitalRenderer)renderer);
        } else if (renderer instanceof PolarPlotRenderer) {
            this.bindToPolarPlotRenderer((PolarPlotRenderer)renderer);
        } else if (renderer instanceof TickCurveRenderer) {
            this.bindToTickCurveRenderer((TickCurveRenderer)renderer);
        } else if (renderer instanceof BoundsRenderer) {
            this.bindToBoundsRenderer((BoundsRenderer)renderer);
        } else if (renderer instanceof ContoursRenderer) {
            this.bindToContoursRenderer((Renderer)((ContoursRenderer)renderer));
        }
        Plot mip = ac.getPlotFor(this.plotElement);
        if (mip != null && (mi = mip.getController().getPlotElementPropsMenuItem()) != null) {
            mi.setIcon(renderer.getListIcon());
        }
        renderer.setId("rend_" + this.plotElement.getId() + "_" + String.format("%04d", renderCount.incrementAndGet()));
        ac.bind(this.plotElement, "legendLabel", renderer, "legendLabel", this.getLabelConverter());
        ac.bind(this.plotElement, "displayLegend", renderer, "drawLegendLabel");
        ac.bind(this.plotElement, "renderControl", renderer, "control");
        ac.bind(this.plotElement, "active", renderer, "active");
        logger.exiting("PlotElementController", "setRenderer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResetRanges() {
        DataSourceController dsc;
        this.setStatus("busy: do autorange");
        this.changesSupport.performingChange(this, "resetRanges");
        DataSourceFilter ldsf = this.getDataSourceFilter();
        DataSourceController dataSourceController = dsc = ldsf != null ? ldsf.getController() : null;
        if (dsc == null) {
            logger.warning("expected dsc to be non-null.");
            return;
        }
        try {
            Plot plot = this.dom.controller.getPlotFor(this.plotElement);
            if (plot == null) {
                throw new NullPointerException("unable to find plot for plotElement: " + this.plotElement);
            }
            logger.log(Level.FINE, "renderType: {0}", (Object)this.plotElement.getRenderType());
            PlotElement peleCopy = (PlotElement)this.plotElement.copy();
            peleCopy.setId("");
            peleCopy.setParent("");
            peleCopy.getPlotDefaults().syncTo(plot, Arrays.asList("id", "rowId", "columnId"));
            logger.log(Level.FINE, "doResetRanges for {0}", dsc);
            QDataSet fillDs = dsc.getFillDataSet();
            Map<String, Object> props = dsc.getFillProperties();
            if (props == null || fillDs == null) {
                return;
            }
            String comp = this.plotElement.getComponent();
            if (comp.length() > 0) {
                try {
                    fillDs = this.processDataSet(comp, fillDs);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, null, ex);
                    this.changesSupport.changePerformed(this, "resetRanges");
                    return;
                }
                if (fillDs == null) {
                    throw new IllegalArgumentException("processDataSet resulted in null result: " + comp);
                }
                if ((props = PlotElementController.processProperties(comp, props)).isEmpty()) {
                    props = AutoplotUtil.extractProperties(fillDs);
                }
            }
            if (this.dom.getOptions().isAutolabelling()) {
                PlotElementController.doMetadata(peleCopy, props, fillDs);
                String appliedFilters = dsc.getAppliedFiltersString();
                if (appliedFilters != null) {
                    appliedFilters = appliedFilters.trim();
                }
                String title = peleCopy.getPlotDefaults().getTitle();
                if (fillDs.property("CONTEXT_0") != null && dsc.reduceDataSetString != null) {
                    title = title + "!c%{CONTEXT}";
                } else if (!this.plotElement.getComponent().equals("")) {
                    title = title + "!c%{CONTEXT}";
                } else if (appliedFilters != null && appliedFilters.length() > 0) {
                    title = title + "!c" + appliedFilters;
                } else if (fillDs.property("CONTEXT_0") != null) {
                    title = title + "!c%{CONTEXT}";
                }
                peleCopy.getPlotDefaults().setTitle(title);
            }
            if (this.dom.getOptions().isAutoranging()) {
                Renderer newRenderer;
                TimeSeriesBrowse tsb;
                logger.fine("doAutoranging");
                PlotElementController.doAutoranging(peleCopy, props, fillDs, false);
                RenderType rt = peleCopy.getRenderType();
                if (rt == RenderType.series || rt == RenderType.scatter || rt == RenderType.colorScatter || rt == RenderType.hugeScatter || rt == RenderType.fillToZero || rt == RenderType.stairSteps) {
                    if (fillDs.length() > 30000 && rt != RenderType.colorScatter) {
                        logger.fine("dataset has many points, turning off psym");
                        peleCopy.getStyle().setSymbolConnector(PsymConnector.SOLID);
                        peleCopy.getStyle().setPlotSymbol((PlotSymbol)DefaultPlotSymbol.NONE);
                    } else if (fillDs.length() > 500) {
                        logger.fine("dataset has a more than few points, using small symbols");
                        peleCopy.getStyle().setSymbolSize(1.0);
                        peleCopy.getStyle().setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
                    } else {
                        logger.fine("dataset has few points, using small large symbols");
                        peleCopy.getStyle().setSymbolSize(3.0);
                        if (rt == RenderType.stairSteps) {
                            peleCopy.getStyle().setPlotSymbol((PlotSymbol)DefaultPlotSymbol.NONE);
                        } else {
                            peleCopy.getStyle().setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
                        }
                    }
                }
                if ((tsb = dsc.getTsb()) != null) {
                    if (fillDs.rank() == 0) {
                        logger.fine("data is rank 0, no autoranging needs to be done.");
                    } else {
                        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)fillDs);
                        Units xunits = xds.rank() <= 1 ? (Units)xds.property("UNITS") : (Units)xds.property("UNITS", 0);
                        if (xunits != null && UnitsUtil.isTimeLocation((Units)xunits)) {
                            DatumRange tr = tsb.getTimeRange();
                            if (tr == null) {
                                logger.fine("tsb contains no timerange");
                            }
                            peleCopy.getPlotDefaults().getXaxis().setRange(tr);
                        }
                    }
                }
                if ((newRenderer = this.getRenderer()) instanceof SeriesRenderer) {
                    QDataSet d = (QDataSet)fillDs.property("DEPEND_0");
                    if (d != null) {
                        ((SeriesRenderer)newRenderer).setCadenceCheck(d.property("CADENCE") != null);
                    } else {
                        ((SeriesRenderer)newRenderer).setCadenceCheck(true);
                    }
                }
            } else {
                this.setStatus("autoranging is disabled");
                logger.info("autoranging is disabled");
            }
            if (this.plotElement.getComponent().equals("") && this.plotElement.isAutoLabel()) {
                this.plotElement.setLegendLabelAutomatically(peleCopy.getLegendLabel());
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("done, autorange  x:%s, y:%s ", peleCopy.getPlotDefaults().getXaxis().getRange().toString(), peleCopy.getPlotDefaults().getYaxis().getRange().toString()));
            }
            this.plotElement.setPlotDefaults(peleCopy.getPlotDefaults());
            this.plotElement.style.syncTo(peleCopy.style);
            this.plotElement.renderType = peleCopy.renderType;
            if (this.dom.getOptions().isAutoranging()) {
                this.setStatus("done, autorange");
            }
        }
        finally {
            this.changesSupport.changePerformed(this, "resetRanges");
        }
    }

    private static void doMetadata(PlotElement peleCopy, Map<String, Object> properties, QDataSet fillDs) {
        peleCopy.getPlotDefaults().getXaxis().setLabel("");
        peleCopy.getPlotDefaults().getYaxis().setLabel("");
        peleCopy.getPlotDefaults().getZaxis().setLabel("");
        peleCopy.getPlotDefaults().setTitle("");
        peleCopy.setLegendLabelAutomatically("");
        PlotElementController.doInterpretMetadata(peleCopy, properties, peleCopy.getRenderType());
        PlotElementUtil.unitsCheck(properties, fillDs);
    }

    private static void doInterpretMetadata(PlotElement peleCopy, Map properties, RenderType spec) {
        Map yprop;
        Map xprop;
        Map m;
        Object v2;
        Plot plotDefaults = peleCopy.getPlotDefaults();
        Object v = properties.get("TITLE");
        if (v != null) {
            plotDefaults.setTitle((String)v);
        }
        String legendLabel = null;
        v = properties.get("NAME");
        if (v != null) {
            legendLabel = (String)v;
        }
        if ((v = properties.get("LABEL")) != null) {
            legendLabel = (String)v;
        }
        if (legendLabel != null) {
            peleCopy.setLegendLabelAutomatically(legendLabel);
        }
        if (spec == RenderType.spectrogram || spec == RenderType.nnSpectrogram || spec == RenderType.stackedHistogram) {
            v = properties.get("SCALE_TYPE");
            if (v != null) {
                plotDefaults.getZaxis().setLog(v.equals("log"));
            }
            if ((v = properties.get("LABEL")) != null) {
                plotDefaults.getZaxis().setLabel((String)v);
            }
            if ((v = properties.get("DEPEND_1")) != null && (v2 = (m = (Map)v).get("LABEL")) != null) {
                plotDefaults.getYaxis().setLabel((String)v2);
            }
            if ((m = (Map)properties.get("PLANE_0")) != null) {
                v = m.get("LABEL");
                if (v != null) {
                    plotDefaults.getZaxis().setLabel((String)v);
                }
                if ((v = m.get("TITLE")) != null) {
                    plotDefaults.setTitle((String)v);
                }
            }
        } else if (spec == RenderType.image) {
            xprop = null;
            xprop = (Map)properties.get("DEPEND_0");
            yprop = (Map)properties.get("DEPEND_1");
            if (xprop != null) {
                v = xprop.get("LABEL");
                if (v != null) {
                    plotDefaults.xaxis.setLabel((String)v);
                }
                if ((v = xprop.get("SCALE_TYPE")) != null) {
                    plotDefaults.getXaxis().setLog(v.equals("log"));
                }
            }
            if (yprop != null) {
                v = (String)yprop.get("LABEL");
                if (v != null) {
                    plotDefaults.yaxis.setLabel((String)v);
                }
                if ((v = yprop.get("SCALE_TYPE")) != null) {
                    plotDefaults.getYaxis().setLog(v.equals("log"));
                }
            }
        } else {
            Map prop;
            xprop = null;
            QDataSet bundle1 = (QDataSet)properties.get("BUNDLE_1");
            if (bundle1 != null) {
                xprop = (Map)properties.get("DEPEND_0");
                if (xprop == null) {
                    xprop = DataSetUtil.getProperties((QDataSet)DataSetOps.slice0((QDataSet)bundle1, (int)0));
                }
                if (spec != RenderType.colorScatter) {
                    prop = properties;
                    yprop = properties;
                } else {
                    prop = DataSetUtil.getProperties((QDataSet)DataSetOps.slice0((QDataSet)bundle1, (int)(bundle1.length() - 1)));
                    yprop = DataSetUtil.getProperties((QDataSet)DataSetOps.slice0((QDataSet)bundle1, (int)1));
                }
            } else {
                prop = properties;
                yprop = properties;
                v = properties.get("PLANE_0");
                if (v != null) {
                    yprop = prop;
                    prop = (Map)v;
                }
            }
            v = yprop.get("SCALE_TYPE");
            if (v != null) {
                plotDefaults.getYaxis().setLog(v.equals("log"));
            }
            if ((v = yprop.get("LABEL")) != null) {
                plotDefaults.getYaxis().setLabel((String)v);
            }
            if (xprop != null && (v = xprop.get("LABEL")) != null) {
                plotDefaults.getXaxis().setLabel((String)v);
            }
            if (spec == RenderType.colorScatter) {
                v = prop.get("LABEL");
                if (v != null) {
                    plotDefaults.getZaxis().setLabel((String)v);
                }
                if ((v = prop.get("TITLE")) != null) {
                    plotDefaults.setTitle((String)v);
                }
            }
        }
        v = properties.get("DEPEND_0");
        if (v != null && (v2 = (m = (Map)v).get("LABEL")) != null) {
            plotDefaults.getXaxis().setLabel((String)v2);
        }
    }

    public static void doAutoranging(PlotElement peleCopy, Map<String, Object> props, QDataSet fillDs) {
        PlotElementController.doAutoranging(peleCopy, props, fillDs, false);
    }

    private static void copyAutorange(Plot p, QDataSet bounds) {
        assert (Schemes.isBoundingBox((QDataSet)bounds));
        p.xaxis.setRange(DataSetUtil.asDatumRange((QDataSet)bounds.slice(0), (boolean)true));
        p.xaxis.setLog("log".equals(bounds.slice(0).property("SCALE_TYPE")));
        p.yaxis.setRange(DataSetUtil.asDatumRange((QDataSet)bounds.slice(1), (boolean)true));
        p.yaxis.setLog("log".equals(bounds.slice(1).property("SCALE_TYPE")));
        if (bounds.length() > 2) {
            p.zaxis.setRange(DataSetUtil.asDatumRange((QDataSet)bounds.slice(2), (boolean)true));
            p.zaxis.setLog("log".equals(bounds.slice(2).property("SCALE_TYPE")));
        } else {
            p.zaxis.setAutoRange(false);
        }
    }

    public static void doAutoranging(PlotElement peleCopy, Map<String, Object> props, QDataSet fillDs, boolean ignoreDsProps) {
        RenderType spec = peleCopy.getRenderType();
        if (fillDs.rank() == 0 && spec != RenderType.eventsBar) {
            spec = RenderType.digital;
        }
        if (props == null) {
            props = Collections.EMPTY_MAP;
        }
        logger.log(Level.FINE, "doAutoranging for {0}", (Object)spec);
        if (spec == RenderType.spectrogram || spec == RenderType.nnSpectrogram || spec == RenderType.stackedHistogram) {
            QDataSet zds;
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)fillDs);
            if (xds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    int xtag = 0;
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet xds1 = (QDataSet)fillDs.property("DEPEND_0", i);
                        if (xds1 == null) {
                            xds1 = Ops.linspace((double)xtag, (double)(xtag + fillDs.length(i) - 1), (int)fillDs.length(i));
                            xtag += fillDs.length(i);
                        }
                        ds.join(xds1);
                    }
                    xds = ds;
                } else {
                    xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
                }
            }
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)fillDs);
            if (fillDs.rank() == 2 && SemanticOps.isJoin((QDataSet)fillDs)) {
                yds = null;
            }
            Map yprops = (Map)props.get("DEPEND_1");
            if (yds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet yds1 = (QDataSet)fillDs.property("DEPEND_1", i);
                        if (yds1 == null) {
                            int n = fillDs.slice(i).length();
                            yds1 = Ops.linspace((double)0.0, (double)(n - 1), (int)n);
                        }
                        ds.join(yds1);
                    }
                    yds = ds;
                } else if (fillDs.property("JOIN_0") == null && fillDs.length() > 0 && fillDs.property("DEPEND_0", 0) != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    Units u = null;
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet tds = (QDataSet)fillDs.property("DEPEND_0", i);
                        if (u == null) {
                            u = SemanticOps.getUnits((QDataSet)tds);
                        } else {
                            Units tu = SemanticOps.getUnits((QDataSet)tds);
                            if (tu == null) {
                                tu = Units.dimensionless;
                            }
                            if (tu != u) {
                                throw new IllegalArgumentException("Unequal units: wanted " + u + " got " + tu);
                            }
                        }
                        ds.join(tds);
                    }
                    ds.putProperty("UNITS", u);
                    yds = ds;
                } else if (fillDs.rank() > 1) {
                    yds = DataSetUtil.indexGenDataSet((int)fillDs.length(0));
                } else {
                    yds = DataSetUtil.indexGenDataSet((int)10);
                    yprops = null;
                }
            }
            if (fillDs.rank() > 1 && yds.length() == fillDs.length(0) && yds.length() > 3) {
                zds = fillDs;
            } else {
                zds = SemanticOps.getDependentDataSet((QDataSet)fillDs);
                if (Schemes.isLegacyXYZScatter((QDataSet)zds)) {
                    zds = (QDataSet)fillDs.property("PLANE_0");
                }
            }
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            Units yunits = SemanticOps.getUnits((QDataSet)yds);
            Units zunits = SemanticOps.getUnits((QDataSet)zds);
            if (UnitsUtil.isOrdinalMeasurement((Units)xunits) || UnitsUtil.isOrdinalMeasurement((Units)yunits) || UnitsUtil.isOrdinalMeasurement((Units)zunits)) {
                return;
            }
            AutoRangeUtil.AutoRangeDescriptor desc = AutoRangeUtil.autoRange(zds, props, ignoreDsProps);
            logger.log(Level.FINE, "desc.range={0}", desc.range);
            AutoRangeUtil.AutoRangeDescriptor xdesc = AutoplotUtil.autoRange(xds, (Map)props.get("DEPEND_0"), ignoreDsProps);
            logger.log(Level.FINE, "xdesc.range={0}", xdesc.range);
            AutoRangeUtil.AutoRangeDescriptor ydesc = AutoplotUtil.autoRange(yds, yprops, ignoreDsProps);
            logger.log(Level.FINE, "ydesc.range={0}", ydesc.range);
            peleCopy.getPlotDefaults().getZaxis().setRange(desc.range);
            peleCopy.getPlotDefaults().getZaxis().setLog(desc.log);
            logger.log(Level.FINE, "xaxis.isAutoRange={0}", peleCopy.getPlotDefaults().getXaxis().isAutoRange());
            peleCopy.getPlotDefaults().getXaxis().setLog(xdesc.log);
            peleCopy.getPlotDefaults().getXaxis().setRange(xdesc.range);
            peleCopy.getPlotDefaults().getYaxis().setLog(ydesc.log);
            peleCopy.getPlotDefaults().getYaxis().setRange(ydesc.range);
        } else if (spec == RenderType.pitchAngleDistribution) {
            QDataSet qube = PitchAngleDistributionRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                peleCopy.getPlotDefaults().getXaxis().setRange(DataSetUtil.asDatumRange((QDataSet)qube.slice(0), (boolean)true));
                String label = (String)qube.slice(0).property("LABEL");
                peleCopy.getPlotDefaults().getXaxis().setLabel(label == null ? "" : label);
                peleCopy.getPlotDefaults().getYaxis().setRange(DataSetUtil.asDatumRange((QDataSet)qube.slice(1), (boolean)true));
                label = (String)qube.slice(1).property("LABEL");
                peleCopy.getPlotDefaults().getYaxis().setLabel(label == null ? "" : label);
                peleCopy.getPlotDefaults().getZaxis().setRange(DataSetUtil.asDatumRange((QDataSet)qube.slice(2), (boolean)true));
                peleCopy.getPlotDefaults().getZaxis().setLog("log".equals(qube.slice(2).property("SCALE_TYPE")));
            }
        } else if (spec == RenderType.polar) {
            QDataSet qube = PolarPlotRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                PlotElementController.copyAutorange(peleCopy.getPlotDefaults(), qube);
                String label = (String)qube.slice(0).property("LABEL");
                peleCopy.getPlotDefaults().getXaxis().setLabel(label == null ? "" : label);
                label = (String)qube.slice(1).property("LABEL");
                peleCopy.getPlotDefaults().getYaxis().setLabel(label == null ? "" : label);
            }
        } else if (spec == RenderType.digital) {
            QDataSet qube = DigitalRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                PlotElementController.copyAutorange(peleCopy.getPlotDefaults(), qube);
            }
        } else if (spec == RenderType.contour) {
            QDataSet qube = ContoursRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                PlotElementController.copyAutorange(peleCopy.getPlotDefaults(), qube);
            }
        } else if (spec == RenderType.eventsBar) {
            QDataSet qube = EventsRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                PlotElementController.copyAutorange(peleCopy.getPlotDefaults(), qube);
                peleCopy.getPlotDefaults().getYaxis().setAutoRange(false);
                peleCopy.getPlotDefaults().getYaxis().setVisible(false);
            }
        } else if (spec == RenderType.vectorPlot) {
            QDataSet qube = VectorPlotRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                PlotElementController.copyAutorange(peleCopy.getPlotDefaults(), qube);
            }
        } else if (spec == RenderType.orbitPlot) {
            QDataSet qube = TickCurveRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                PlotElementController.copyAutorange(peleCopy.getPlotDefaults(), qube);
            }
        } else if (spec == RenderType.image) {
            QDataSet qube = RGBImageRenderer.doAutorange((QDataSet)fillDs);
            if (qube != null) {
                PlotElementController.copyAutorange(peleCopy.getPlotDefaults(), qube);
            }
        } else if (spec != RenderType.internal) {
            if (spec == RenderType.bounds) {
                QDataSet qube = BoundsRenderer.doAutorange((QDataSet)fillDs);
                if (qube != null) {
                    String rt;
                    DatumRange xrange = DataSetUtil.asDatumRange((QDataSet)qube.slice(0), (boolean)true);
                    DatumRange yrange = DataSetUtil.asDatumRange((QDataSet)qube.slice(1), (boolean)true);
                    if (props.containsKey("RENDER_TYPE") && (rt = (String)props.get("RENDER_TYPE")).contains("polar=T")) {
                        yrange = xrange = DatumRange.newRange((Datum)yrange.max().negative(), (Datum)yrange.max());
                    }
                    peleCopy.getPlotDefaults().getXaxis().setRange(xrange);
                    peleCopy.getPlotDefaults().getYaxis().setRange(yrange);
                    peleCopy.getPlotDefaults().getZaxis().setAutoRange(false);
                }
            } else {
                AutoRangeUtil.AutoRangeDescriptor xdesc;
                int i;
                AutoRangeUtil.AutoRangeDescriptor ydesc;
                QDataSet depend0;
                if (SemanticOps.isBundle((QDataSet)fillDs)) {
                    depend0 = SemanticOps.xtagsDataSet((QDataSet)fillDs);
                    if (spec == RenderType.colorScatter) {
                        ydesc = AutoRangeUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)1), props, ignoreDsProps);
                    } else if (spec == RenderType.scatter && fillDs.property("DEPEND_0") == null) {
                        ydesc = AutoRangeUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)1), props, ignoreDsProps);
                    } else {
                        ydesc = AutoRangeUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)(fillDs.length(0) - 1)), props, ignoreDsProps);
                        Units u = ydesc.range.getUnits();
                        for (i = fillDs.length(0) - 2; i >= 0; --i) {
                            QDataSet ds1 = DataSetOps.unbundle((QDataSet)fillDs, (int)i);
                            if (i == 0 && depend0 != null && Ops.equivalent((QDataSet)ds1, (QDataSet)depend0)) continue;
                            AutoRangeUtil.AutoRangeDescriptor ydesc1 = AutoRangeUtil.autoRange(ds1, props, ignoreDsProps);
                            if (ydesc1.range.getUnits().isConvertibleTo(u)) {
                                if (i == 0 && fillDs.length(0) == 2) continue;
                                ydesc.range = DatumRangeUtil.union((DatumRange)ydesc.range, (DatumRange)ydesc1.range);
                                continue;
                            }
                            Units u1 = ydesc1.range.getUnits();
                            DatumRange r1 = new DatumRange(ydesc1.range.min().doubleValue(u1), ydesc1.range.max().doubleValue(u1), u);
                            ydesc.range = DatumRangeUtil.union((DatumRange)ydesc.range, (DatumRange)r1);
                        }
                    }
                } else {
                    ydesc = AutoRangeUtil.autoRange(fillDs, props, ignoreDsProps);
                    depend0 = (QDataSet)fillDs.property("DEPEND_0");
                }
                peleCopy.getPlotDefaults().getYaxis().setLog(ydesc.log);
                peleCopy.getPlotDefaults().getYaxis().setRange(ydesc.range);
                QDataSet xds = depend0;
                if (SemanticOps.isJoin((QDataSet)fillDs) && fillDs.length() > 0 && fillDs.rank() == 3) {
                    xds = (QDataSet)fillDs.slice(0).property("DEPEND_0");
                    if (xds != null) {
                        for (i = 1; i < fillDs.length(); ++i) {
                            xds = Ops.concatenate((QDataSet)xds, (QDataSet)((QDataSet)fillDs.slice(i).property("DEPEND_0")));
                        }
                    } else {
                        int n = fillDs.slice(0).length();
                        for (int i2 = 1; i2 < fillDs.length(); ++i2) {
                            n += fillDs.slice(i2).length();
                        }
                        xds = DataSetUtil.indexGenDataSet((int)n);
                    }
                } else if (xds == null) {
                    xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
                }
                if (fillDs.length() == 1 && SemanticOps.isRank2Waveform((QDataSet)fillDs)) {
                    QDataSet waveform = Ops.flattenWaveform((QDataSet)fillDs);
                    xds = SemanticOps.xtagsDataSet((QDataSet)waveform);
                    xdesc = AutoRangeUtil.autoRange(xds, (Map)props.get("DEPEND_0"), ignoreDsProps);
                } else {
                    xdesc = AutoRangeUtil.autoRange(xds, (Map)props.get("DEPEND_0"), ignoreDsProps);
                }
                peleCopy.getPlotDefaults().getXaxis().setLog(xdesc.log);
                if (UnitsUtil.isOrdinalMeasurement((Units)xdesc.range.getUnits())) {
                    xdesc.range = DatumRange.newRange((double)xdesc.range.min().doubleValue(xdesc.range.getUnits()), (double)xdesc.range.max().doubleValue(xdesc.range.getUnits()));
                }
                peleCopy.getPlotDefaults().getXaxis().setRange(xdesc.range);
                if (spec == RenderType.colorScatter) {
                    if (fillDs.property("BUNDLE_1") != null) {
                        AutoRangeUtil.AutoRangeDescriptor zdesc = AutoRangeUtil.autoRange(DataSetOps.unbundle((QDataSet)fillDs, (int)(fillDs.length(0) - 1)), null, ignoreDsProps);
                        peleCopy.getPlotDefaults().getZaxis().setLog(zdesc.log);
                        peleCopy.getPlotDefaults().getZaxis().setRange(zdesc.range);
                    } else {
                        QDataSet plane0 = (QDataSet)fillDs.property("PLANE_0");
                        if (plane0 != null) {
                            AutoRangeUtil.AutoRangeDescriptor zdesc = AutoRangeUtil.autoRange(plane0, (Map)props.get("PLANE_0"), ignoreDsProps);
                            peleCopy.getPlotDefaults().getZaxis().setLog(zdesc.log);
                            peleCopy.getPlotDefaults().getZaxis().setRange(zdesc.range);
                        } else {
                            logger.warning("expected color plane_0");
                        }
                    }
                } else {
                    peleCopy.getPlotDefaults().getZaxis().setAutoRange(false);
                }
            }
        }
    }

    private boolean doUnitsCheck(QDataSet fillDs) {
        Units zunits;
        Units yunits;
        Units xunits;
        RenderType spec = this.plotElement.getRenderType();
        DatumRange xrange = this.plotElement.getPlotDefaults().getXaxis().getRange();
        DatumRange yrange = this.plotElement.getPlotDefaults().getYaxis().getRange();
        DatumRange zrange = this.plotElement.getPlotDefaults().getZaxis().getRange();
        if (spec == RenderType.spectrogram || spec == RenderType.nnSpectrogram) {
            QDataSet yds;
            QDataSet xds = (QDataSet)fillDs.property("DEPEND_0");
            if (xds == null) {
                if (fillDs.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    int xtag = 0;
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet xds1 = (QDataSet)fillDs.property("DEPEND_0", i);
                        if (xds1 == null) {
                            xds1 = Ops.linspace((double)xtag, (double)(xtag + fillDs.length(i) - 1), (int)fillDs.length(i));
                            xtag += fillDs.length(i);
                        }
                        ds.join(xds1);
                    }
                    xds = ds;
                } else {
                    xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
                }
            }
            if ((yds = (QDataSet)fillDs.property("DEPEND_1")) == null) {
                if (fillDs.property("JOIN_0") != null && fillDs.length() > 0) {
                    QDataSet yds1 = (QDataSet)fillDs.property("DEPEND_1", 0);
                    if (yds1 != null) {
                        JoinDataSet ds = new JoinDataSet(yds1.rank() + 1);
                        for (int i = 0; i < fillDs.length(); ++i) {
                            yds1 = (QDataSet)fillDs.property("DEPEND_1", i);
                            if (yds1 == null) {
                                yds1 = Ops.linspace((double)0.0, (double)(fillDs.length(i, 0) - 1), (int)fillDs.length(i, 0));
                            }
                            ds.join(yds1);
                        }
                        yds = ds;
                    } else {
                        yds = Ops.indgen((int)fillDs.slice(0).length());
                    }
                } else if (fillDs.property("JOIN_0") == null && fillDs.length() > 0 && fillDs.property("DEPEND_0", 0) != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    Units u = null;
                    for (int i = 0; i < fillDs.length(); ++i) {
                        QDataSet tds = (QDataSet)fillDs.property("DEPEND_0", i);
                        if (u == null) {
                            u = (Units)tds.property("UNITS");
                            if (u == null) {
                                u = Units.dimensionless;
                            }
                        } else {
                            Units tu = (Units)tds.property("UNITS");
                            if (tu == null) {
                                tu = Units.dimensionless;
                            }
                            if (tu != u) {
                                throw new IllegalArgumentException("Inconvertable units: wanted " + u);
                            }
                        }
                        ds.join(tds);
                    }
                    ds.putProperty("UNITS", u);
                    yds = ds;
                } else {
                    yds = fillDs.rank() > 1 ? DataSetUtil.indexGenDataSet((int)fillDs.length(0)) : DataSetUtil.indexGenDataSet((int)10);
                }
            }
            xunits = SemanticOps.getUnits((QDataSet)xds);
            yunits = SemanticOps.getUnits((QDataSet)yds);
            zunits = SemanticOps.getUnits((QDataSet)fillDs);
        } else {
            QDataSet depend0;
            if (spec == RenderType.pitchAngleDistribution) {
                return true;
            }
            if (spec == RenderType.polar) {
                return true;
            }
            if (spec == RenderType.eventsBar) {
                return true;
            }
            if (spec == RenderType.vectorPlot) {
                return true;
            }
            if (spec == RenderType.orbitPlot) {
                return true;
            }
            if (spec == RenderType.digital) {
                return true;
            }
            if (spec == RenderType.internal) {
                return true;
            }
            if (SemanticOps.isBundle((QDataSet)fillDs)) {
                depend0 = (QDataSet)fillDs.property("DEPEND_0");
                if (depend0 == null) {
                    yunits = SemanticOps.getUnits((QDataSet)DataSetOps.unbundle((QDataSet)fillDs, (int)1));
                    depend0 = DataSetOps.unbundle((QDataSet)fillDs, (int)0);
                } else {
                    yunits = SemanticOps.getUnits((QDataSet)DataSetOps.unbundle((QDataSet)fillDs, (int)0));
                }
            } else {
                yunits = SemanticOps.getUnits((QDataSet)fillDs);
                depend0 = (QDataSet)fillDs.property("DEPEND_0");
            }
            if (fillDs.rank() == 0) {
                return true;
            }
            QDataSet xds = depend0;
            if (xds == null) {
                xds = DataSetUtil.indexGenDataSet((int)fillDs.length());
            }
            xunits = SemanticOps.getUnits((QDataSet)xds);
            zunits = Units.dimensionless;
            if (spec == RenderType.colorScatter) {
                if (fillDs.property("BUNDLE_1") != null) {
                    zunits = SemanticOps.getUnits((QDataSet)DataSetOps.unbundle((QDataSet)fillDs, (int)2));
                } else {
                    QDataSet plane0 = (QDataSet)fillDs.property("PLANE_0");
                    if (plane0 != null) {
                        zunits = Units.dimensionless;
                    } else {
                        logger.warning("expected color plane_0");
                    }
                }
            }
        }
        boolean change = false;
        if (!(xrange.getUnits() != Units.dimensionless || UnitsUtil.isTimeLocation((Units)xunits) || UnitsUtil.isOrdinalMeasurement((Units)xunits) || xunits.isConvertibleTo(xrange.getUnits()))) {
            this.plotElement.getPlotDefaults().getXaxis().setRange(new DatumRange(xrange.min().doubleValue(Units.dimensionless), xrange.max().doubleValue(Units.dimensionless), xunits));
            change = true;
        }
        if (!(yrange.getUnits() != Units.dimensionless || UnitsUtil.isTimeLocation((Units)yunits) || UnitsUtil.isOrdinalMeasurement((Units)yunits) || yunits.isConvertibleTo(yrange.getUnits()))) {
            this.plotElement.getPlotDefaults().getYaxis().setRange(new DatumRange(yrange.min().doubleValue(Units.dimensionless), yrange.max().doubleValue(Units.dimensionless), yunits));
            change = true;
        }
        if (!(zrange.getUnits() != Units.dimensionless || UnitsUtil.isTimeLocation((Units)zunits) || UnitsUtil.isOrdinalMeasurement((Units)zunits) || zunits.isConvertibleTo(zrange.getUnits()))) {
            this.plotElement.getPlotDefaults().getZaxis().setRange(new DatumRange(zrange.min().doubleValue(Units.dimensionless), zrange.max().doubleValue(Units.dimensionless), zunits));
            change = true;
        }
        return change;
    }

    public DasPlot getDasPlot() {
        Plot p;
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("getDasPlot");
        try {
            p = this.dom.controller.getPlotFor(this.plotElement);
        }
        finally {
            lock.unlock();
        }
        if (p == null) {
            return null;
        }
        return p.controller.getDasPlot();
    }

    private DasColorBar getColorbar() {
        Plot p;
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("getColorbar");
        try {
            p = this.dom.controller.getPlotFor(this.plotElement);
        }
        finally {
            lock.unlock();
        }
        if (p == null) {
            throw new IllegalArgumentException("no plot found for element (" + this.plotElement + "," + this.plotElement.getPlotId() + ")");
        }
        return p.controller.getDasColorBar();
    }

    public DataSourceFilter getDataSourceFilter() {
        return this.dsf;
    }

    public Application getApplication() {
        return this.dom;
    }

    private static void setupStyle(PlotElement ele) {
        PlotElementStyle s = ele.getStyle();
        if (null != ele.getRenderType()) {
            switch (ele.getRenderType()) {
                case colorScatter: {
                    s.setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
                    s.setSymbolConnector(PsymConnector.NONE);
                    s.setFillToReference(false);
                    break;
                }
                case series: {
                    s.setSymbolConnector(PsymConnector.SOLID);
                    int size = 0;
                    if (ele.controller != null) {
                        QDataSet processDataSet = ele.controller.processDataSet;
                        QDataSet dataSet = ele.controller.dataSet;
                        if (processDataSet != null) {
                            size = processDataSet.length();
                        } else if (dataSet != null) {
                            int n = size = dataSet.rank() > 0 ? dataSet.length() : 1;
                        }
                    }
                    if (size > 500) {
                        s.setPlotSymbol((PlotSymbol)DefaultPlotSymbol.NONE);
                    } else {
                        s.setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
                    }
                    s.setFillToReference(false);
                    break;
                }
                case scatter: {
                    s.setSymbolConnector(PsymConnector.NONE);
                    s.setPlotSymbol((PlotSymbol)DefaultPlotSymbol.CIRCLES);
                    s.setFillToReference(false);
                    break;
                }
                case stairSteps: {
                    s.setSymbolConnector(PsymConnector.SOLID);
                    s.setPlotSymbol((PlotSymbol)DefaultPlotSymbol.NONE);
                    s.setFillToReference(true);
                    break;
                }
                case fillToZero: {
                    s.setSymbolConnector(PsymConnector.SOLID);
                    s.setFillToReference(true);
                    break;
                }
                case nnSpectrogram: {
                    SpectrogramRenderer.RebinnerEnum r = "true".equals(System.getProperty("useLanlNearestNeighbor", "false")) ? SpectrogramRenderer.RebinnerEnum.lanlNearestNeighbor : SpectrogramRenderer.RebinnerEnum.nearestNeighbor;
                    s.setRebinMethod(r);
                    break;
                }
                case spectrogram: {
                    s.setRebinMethod(SpectrogramRenderer.RebinnerEnum.binAverage);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlotBelow(QDataSet ds, Datum y, boolean above) {
        ApplicationController controller = this.dom.getController();
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("adding slice below");
        try {
            Plot focus = controller.getPlotFor(this.plotElement);
            Plot p = controller.addPlot(focus, above ? LayoutConstants.ABOVE : LayoutConstants.BELOW);
            PlotElement pe = controller.addPlotElement(p, null);
            DataSourceFilter dsfl = controller.getDataSourceFilterFor(pe);
            dsfl.getController().setDataSetInternal(ds);
            p.getYaxis().syncTo(focus.zaxis);
            List<BindingModel> bms = controller.findBindings(this.dom, "timeRange", focus.getXaxis(), "range");
            if (!bms.isEmpty() && UnitsUtil.isTimeLocation((Units)p.getXaxis().getRange().getUnits())) {
                controller.bind(controller.getApplication(), "timeRange", p.getXaxis(), "range");
            }
            p.setTitle(focus.getTitle() + " @ " + y);
        }
        finally {
            lock.unlock();
        }
    }

    protected void maybeCreateDasPeer() {
        Renderer newRenderer;
        if (this.changesSupport.isPendingChanges(PENDING_CREATE_DAS_PEER)) {
            logger.warning("someone else is also changing the peer.");
        }
        this.changesSupport.performingChange(this, PENDING_CREATE_DAS_PEER);
        final Renderer oldRenderer = this.getRenderer();
        Window p = null;
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            p = SwingUtilities.getWindowAncestor((Component)this.plotElement.controller.getDasPlot().getCanvas());
        }
        final Window parent = p;
        DasColorBar cb = null;
        if (RenderTypeUtil.needsColorbar(this.plotElement.getRenderType())) {
            cb = this.getColorbar();
        }
        PlotElementController.setupStyle(this.plotElement);
        RenderType renderType = this.plotElement.getRenderType();
        if (this.getApplication().getOptions().nearestNeighbor && renderType == RenderType.spectrogram) {
            renderType = RenderType.nnSpectrogram;
        }
        if ((newRenderer = AutoplotUtil.maybeCreateRenderer(renderType, oldRenderer, cb, false)) != oldRenderer && newRenderer instanceof SpectrogramRenderer) {
            ((SpectrogramRenderer)newRenderer).setSliceRebinnedData(this.dom.getOptions().isSliceRebinnedData());
            newRenderer.addPropertyChangeListener("rebinner", this.rebinnerListener);
        }
        if (newRenderer != oldRenderer && oldRenderer instanceof SpectrogramRenderer) {
            oldRenderer.addPropertyChangeListener("rebinner", this.rebinnerListener);
        }
        if (cb != null && !this.dom.getController().isValueAdjusting() && RenderTypeUtil.needsColorbar(this.plotElement.getRenderType())) {
            cb.setVisible(true);
        }
        if (oldRenderer != newRenderer || this.getDasPlot() != newRenderer.getParent()) {
            if (oldRenderer != newRenderer) {
                if (newRenderer instanceof SpectrogramRenderer) {
                    this.plotElement.getStyle().setRebinMethod(((SpectrogramRenderer)newRenderer).getRebinner());
                    ((SpectrogramRenderer)newRenderer).getRebinner();
                }
                this.setRenderer(newRenderer);
                if (oldRenderer != null) {
                    oldRenderer.setActive(false);
                    oldRenderer.setColorBar(null);
                }
                if (newRenderer.getColorBar() == cb && cb != null && cb.isVisible()) {
                    DasCanvas c = this.getDasPlot().getCanvas();
                    DasCanvasComponent[] dcc = c.getCanvasComponents();
                    boolean hasColorbarInstalled = false;
                    for (DasCanvasComponent dc : dcc) {
                        if (dc != cb) continue;
                        hasColorbarInstalled = true;
                    }
                    if (!hasColorbarInstalled) {
                        c.add((DasCanvasComponent)cb, cb.getRow(), cb.getColumn());
                    }
                }
            }
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DasPlot plot = PlotElementController.this.getDasPlot();
                        if (plot == null) {
                            System.err.println("pec2326: brace yourself for crash, plot is null!");
                            plot = PlotElementController.this.getDasPlot();
                            if (plot == null) {
                                throw new IllegalStateException("getDasPlot() result was null.");
                            }
                        }
                        DasPlot oldPlot = null;
                        if (oldRenderer != null) {
                            oldPlot = oldRenderer.getParent();
                            if (oldPlot != null && oldPlot != PlotElementController.this.getDasPlot()) {
                                oldRenderer.getParent().removeRenderer(oldRenderer);
                            }
                            if (oldRenderer != newRenderer) {
                                plot.removeRenderer(oldRenderer);
                            }
                        }
                        if (oldPlot == null || oldRenderer != newRenderer) {
                            Application application = PlotElementController.this.dom;
                            synchronized (application) {
                                Renderer[] rends = plot.getRenderers();
                                int best = -1;
                                int myPos = -1;
                                for (int i = 0; i < PlotElementController.this.dom.getPlotElements().length; ++i) {
                                    if (PlotElementController.this.dom.getPlotElements(i) != PlotElementController.this.plotElement) continue;
                                    myPos = i;
                                }
                                List<Renderer> arends = Arrays.asList(rends);
                                Renderer lastRend = null;
                                for (int i = 0; i < myPos; ++i) {
                                    if (i <= best || i >= myPos || !PlotElementController.this.dom.getPlotElements(i).getPlotId().equals(PlotElementController.this.plotElement.getPlotId()) || !arends.contains(PlotElementController.this.dom.getPlotElements(i).getController().getRenderer())) continue;
                                    lastRend = PlotElementController.this.dom.getPlotElements(i).getController().getRenderer();
                                }
                                int indexUnder = -1;
                                for (int j = 0; j < rends.length; ++j) {
                                    if (rends[j] != lastRend) continue;
                                    indexUnder = j;
                                }
                                plot.addRenderer(indexUnder + 1, newRenderer);
                                if (newRenderer instanceof SpectrogramRenderer) {
                                    this.setUpSpectrogramActions(plot);
                                }
                            }
                        }
                        logger.log(Level.FINEST, "plot.addRenderer {0} {1}", new Object[]{plot, newRenderer});
                    }
                    finally {
                        PlotElementController.this.changesSupport.changePerformed(PlotElementController.this, PlotElementController.PENDING_CREATE_DAS_PEER);
                    }
                }

                private void setUpSpectrogramActions(DasPlot plot) {
                    DataRangeSelectionListener ddr;
                    HorizontalDragRangeSelectorMouseModule vsa;
                    VerticalSlicerMouseModule vmm;
                    MouseModule mm = plot.getDasMouseInputAdapter().getModuleByLabel("Horizontal Slice");
                    final HorizontalSlicerMouseModule hmm = (HorizontalSlicerMouseModule)mm;
                    if (hmm != null) {
                        hmm.getSlicer().addAction((Action)new AbstractAction("Plot Below"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LoggerManager.logGuiEvent((ActionEvent)e);
                                boolean above = (e.getModifiers() & 1) == 1;
                                QDataSet ds = hmm.getSlicer().getDataSet();
                                Datum y = hmm.getSlicer().getSliceY();
                                RequestProcessor.invokeLater(() -> PlotElementController.this.addPlotBelow(ds, y, above));
                            }
                        });
                        AnonymousDataSource dss = new AnonymousDataSource(){

                            public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
                                return hmm.getSlicer().getDataSet();
                            }
                        };
                        hmm.getSlicer().addAction(ExportDataPanel.createExportDataAction(parent, (DataSource)dss));
                    }
                    if ((vmm = (VerticalSlicerMouseModule)(mm = plot.getDasMouseInputAdapter().getModuleByLabel("Vertical Slice"))) != null) {
                        AnonymousDataSource dss = new AnonymousDataSource(){

                            public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
                                return vmm.getSlicer().getDataSet();
                            }
                        };
                        vmm.getSlicer().addAction(ExportDataPanel.createExportDataAction(parent, (DataSource)dss));
                    }
                    if ((vsa = (HorizontalDragRangeSelectorMouseModule)(mm = plot.getDasMouseInputAdapter().getModuleByLabel("Interval Average"))) != null && vsa.getDataRangeSelectionListenerCount() > 0 && (ddr = vsa.getDataRangeSelectionListener(0)) instanceof VerticalSpectrogramAverager) {
                        AnonymousDataSource dss = new AnonymousDataSource(){

                            public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
                                return ((VerticalSpectrogramAverager)ddr).getDataSet();
                            }
                        };
                        ((VerticalSpectrogramAverager)ddr).addAction(ExportDataPanel.createExportDataAction(parent, (DataSource)dss));
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        } else {
            this.changesSupport.changePerformed(this, PENDING_CREATE_DAS_PEER);
        }
    }

    private void doResetRenderTypeInt(RenderType renderType) {
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("Reset Render Rype");
        try {
            this.plotElement.propertyChangeSupport.firePropertyChange("renderType", null, (Object)renderType);
        }
        finally {
            lock.unlock();
        }
        this.maybeCreateDasPeer();
    }

    public void doResetRenderType(RenderType renderType) {
        PlotElement parentPele = this.getParentPlotElement();
        if (parentPele != null) {
            parentPele.setRenderType(renderType);
            return;
        }
        for (PlotElement ch : this.getChildPlotElements()) {
            Renderer oldRenderer = ch.getController().getRenderer();
            ch.renderType = renderType;
            ch.getController().maybeCreateDasPeer();
            if (oldRenderer == ch.getController().getRenderer()) continue;
            QDataSet oldDs = oldRenderer == null ? null : oldRenderer.getDataSet();
            ch.getController().getRenderer().setDataSet(oldDs);
        }
        this.doResetRenderTypeInt(renderType);
    }

    public void bindToSeriesRenderer(SeriesRenderer seriesRenderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "lineWidth", seriesRenderer, "lineWidth");
        ac.bind(this.plotElement.style, "color", seriesRenderer, "color");
        ac.bind(this.plotElement.style, "symbolSize", seriesRenderer, "symSize");
        ac.bind(this.plotElement.style, "symbolConnector", seriesRenderer, "psymConnector");
        ac.bind(this.plotElement.style, "plotSymbol", seriesRenderer, "psym");
        ac.bind(this.plotElement.style, "fillColor", seriesRenderer, "fillColor");
        ac.bind(this.plotElement.style, "fillToReference", seriesRenderer, "fillToReference");
        ac.bind(this.plotElement.style, "reference", seriesRenderer, "reference");
        ac.bind(this.plotElement.style, "fillDirection", seriesRenderer, "fillDirection");
        ac.bind(this.plotElement.style, "showLimits", seriesRenderer, "showLimits");
        ac.bind(this.plotElement.style, "drawError", seriesRenderer, "drawError");
        ac.bind(this.plotElement.style, "errorBarType", seriesRenderer, "errorBarType");
        ac.bind(this.plotElement.style, "antiAliased", seriesRenderer, "antiAliased");
        ac.bind(this.plotElement, "cadenceCheck", seriesRenderer, "cadenceCheck");
        if (seriesRenderer.getColorBar() != null) {
            ac.bind(this.plotElement.style, "colortable", seriesRenderer.getColorBar(), "type");
        }
    }

    public void bindToSpectrogramRenderer(SpectrogramRenderer spectrogramRenderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "rebinMethod", spectrogramRenderer, "rebinner");
        ac.bind(this.plotElement, "cadenceCheck", spectrogramRenderer, "cadenceCheck");
        if (spectrogramRenderer.getColorBar() != null) {
            ac.bind(this.plotElement.style, "colortable", spectrogramRenderer.getColorBar(), "type");
        }
    }

    public void bindToImageVectorDataSetRenderer(HugeScatterRenderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
    }

    public void bindToEventsRenderer(EventsRenderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
    }

    public void bindToDigitalRenderer(DigitalRenderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
    }

    public void bindToPolarPlotRenderer(PolarPlotRenderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
        ac.bind(this.plotElement.style, "lineWidth", renderer, "lineWidth");
    }

    public void bindToTickCurveRenderer(TickCurveRenderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
        ac.bind(this.plotElement.style, "lineWidth", renderer, "lineWidth");
    }

    public void bindToContoursRenderer(Renderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
        ac.bind(this.plotElement.style, "lineWidth", renderer, "lineThick");
    }

    private void bindToBoundsRenderer(BoundsRenderer renderer) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.plotElement.style, "color", renderer, "color");
    }

    private Converter getLabelConverter() {
        LabelConverter r = new LabelConverter(this.dom, null, null, this.plotElement, null);
        return r;
    }

    @Override
    public boolean isPendingChanges() {
        DataSourceFilter ldsf = this.getDataSourceFilter();
        if (ldsf != null) {
            return ldsf.controller.isPendingChanges() || super.isPendingChanges();
        }
        return super.isPendingChanges();
    }

    @Override
    public void pendingChanges(Map<Object, Object> changes) {
        super.pendingChanges(changes);
        DataSourceFilter ldsf = this.getDataSourceFilter();
        if (ldsf != null) {
            ldsf.controller.pendingChanges(changes);
        }
    }

    private void setStatus(String string) {
        this.dom.controller.setStatus(string);
    }

    public String toString() {
        return "" + this.plotElement + " controller";
    }

    private void setParentComponentListener(PropertyChangeListener pcl) {
        this.parentComponentLister = pcl;
    }

    private PropertyChangeListener getParentComponentLister() {
        return this.parentComponentLister;
    }
}

